--[[
sets.lua
The loot tables for all item sets and collections is defined here.
]]

AtlasLoot_Data["AtlasLootSetItems"] = {
    EmptyInstance = {};

-- Pre 60 Sets
    
    DEADMINES = {
        { 0, "INV_Box_01", "=q6=#pre60s1#", "=ec1=#a2#. =q1=#z1#" },
        { 10399, "INV_Chest_Leather_08", "=q3=Blackened Defias Armor", "=ds=#s5#, =q2=#n6#", "14.77%" },
        { 10401, "INV_Gauntlets_18", "=q2=Blackened Defias Gloves", "=ds=#s9#, =q2=#n9#", "1.76%" },
        { 10403, "INV_Belt_26", "=q2=Blackened Defias Belt", "=ds=#s10#, =q2=#n7#", "23.26%" },
        { 10400, "INV_Pants_12", "=q2=Blackened Defias Leggings", "=ds=#s11#, =q2=#n9#", "1.64%" },
        { 10402, "INV_Boots_05", "=q2=Blackened Defias Boots", "=ds=#s12#, =q2=#n8#", "1.23%" },
        }; 

    WAILING = {
        { 0, "INV_Box_01", "=q6=#pre60s2#", "=ec1=#a2#. =q1=#z2#" },
        { 6473, "INV_Shirt_16", "=q2=Armor of the Fang", "=ds=#s5#, =q2=#n5#", "52.05%" },
        { 10413, "INV_Gauntlets_18", "=q2=Gloves of the Fang", "=ds=#s9#, =q2=#n4#", "1.20%" },
        { 10412, "INV_Belt_30", "=q2=Belt of the Fang", "=ds=#s10#, =q2=#n2#", "8.64%" },
        { 10410, "INV_Pants_11", "=q3=Leggings of the Fang", "=ds=#s11#, =q2=#n1#", "16.03%" },
        { 10411, "INV_Boots_04", "=q2=Footpads of the Fang", "=ds=#s12#, =q2=#n3#", "19.08%" },
        }; 

    SCARLET = {
        { 0, "INV_Box_01", "=q6=#pre60s3#", "=ec1=#a3#. =q1=#z3#" },
        { 10328, "INV_Chest_Chain_07", "=q3=Scarlet Chestpiece", "=ds=#s5#, =q2=#n12#", "0.3%"},
        { 10333, "INV_Bracer_03", "=q2=Scarlet Wristguards", "=ds=#s8#, =q2=#n15#", "1.6%"},
        { 10331, "INV_Gauntlets_19", "=q2=Scarlet Gauntlets", "=ds=#s9#, =q2=#n13#", "1.7%" },
        { 10329, "INV_Belt_06", "=q2=Scarlet Belt", "=ds=#s10#, =q2=#n10#", "1.6%"},
        { 10330, "INV_Pants_03", "=q3=Scarlet Leggings", "=ds=#s11#, =q2=#n14#", "13.2%"},
        { 10332, "INV_Boots_02", "=q3=Scarlet Boots", "=ds=#s12#, =q2=#n11#", "0.1%"},
        };

    BLACKROCKD = {
        { 0, "INV_Box_01", "=q6=#pre60s4#", "=ec1=#a3#. =q1=#z4#" },
        { 11729, "INV_Helmet_01", "=q3=Savage Gladiator Helm", "=ds=#s1#, =q2=#brd3#, #brd5#", "10.08%" },
        { 11726, "INV_Chest_Chain_15", "=q4=Savage Gladiator Chain", "=ds=#s5#, =q2=#brd3#", "14.52%" },
        { 11730, "INV_Gauntlets_04", "=q3=Savage Gladiator Grips", "=ds=#s9#, =q2=#brd2#", "14.12%"},
        { 11728, "INV_Pants_03", "=q3=Savage Gladiator Leggings", "=ds=#s11#, =q2=#brd6#", "14.95%" },
        { 11731, "INV_Boots_01", "=q3=Savage Gladiator Greaves", "=ds=#s12#, =q2=#brd1#", "15.14%" },
        };

    IRONWEAVE = {
        { 0, "INV_Box_01", "=q6=#pre60s5#", "=ec1=#a1#, =q1=#m1# #c5#, #c3#, #c8#" },
        { 22302, "INV_Helmet_30", "=q3=Ironweave Cowl", "=ds=#s1#, =q2=#n16# (#z9#)", "27.72%" },
        { 22305, "INV_Shoulder_05", "=q3=Ironweave Mantle", "=ds=#s3#, =q2=#n17# (#z4#)", "30.39%" },
        { 22301, "INV_Chest_Cloth_48", "=q3=Ironweave Robe", "=ds=#s5#, =q2=#n18# (#z6#)", "19.00%" },
        { 22313, "INV_Bracer_13", "=q3=Ironweave Bracers", "=ds=#s8#, =q2=#n19# (#z10#)", "18.16%" },
        { 22304, "INV_Gauntlets_27", "=q3=Ironweave Gloves", "=ds=#s9#, =q2=#n20# (#z13#)", "16.24%" },
        { 22306, "INV_Belt_03", "=q3=Ironweave Belt", "=ds=#s10#, =q2=#n21# (#z10#)", "20.28%" }, 
        { 22303, "INV_Pants_08", "=q3=Ironweave Pants", "=ds=#s11#, =q2=#n22# (#z5#)", "23.33%" },
        { 22311,"INV_Boots_Cloth_05","=q3=Ironweave Boots", "=ds=#s12#, =q2=#n23# (#z9#)", "12.31%" },
        };

    ScholoCloth = {
        { 0, "INV_Box_01", "=q6=#pre60s6#", "=ec1=#a1#. =q1=#z5#" },
        { 14633, "INV_Shoulder_02", "=q3=Necropile Mantle", "=ds=#s3#", "1.12%" },
        { 14626, "INV_Chest_Cloth_43", "=q3=Necropile Robe", "=ds=#s5#", "1.27%" },
        { 14629, "INV_Bracer_07", "=q3=Necropile Cuffs", "=ds=#s8#", "1.03%" },
        { 14632, "INV_Pants_08", "=q3=Necropile Leggings", "=ds=#s11#", "0.85%" },
        { 14631, "INV_Boots_05", "=q3=Necropile Boots", "=ds=#s12#", "0.88%" },
        };

    ScholoLeather = {
        { 0, "INV_Box_01", "=q6=#pre60s7#", "=ec1=#a2#. =q1=#z5#" },
        { 14637, "INV_Chest_Leather_03", "=q3=Cadaverous Armor", "=ds=#s5#", "1.51%" },
        { 14640, "INV_Gauntlets_15", "=q3=Cadaverous Gloves", "=ds=#s9#", "0.82%" },
        { 14636, "INV_Belt_16", "=q3=Cadaverous Belt", "=ds=#s10#", "0.60%" },
        { 14638, "INV_Pants_07", "=q3=Cadaverous Leggings", "=ds=#s11#", "1.09%" },
        { 14641, "INV_Boots_05", "=q3=Cadaverous Walkers", "=ds=#s12#", "0.67%" },
        };

    ScholoMail = {
        { 0, "INV_Box_01", "=q6=#pre60s8#", "=ec1=#a3#. =q1=#z5#" },
        { 14611, "INV_Chest_Leather_05", "=q3=Bloodmail Hauberk", "=ds=#s5#", "0.54%" },
        { 14615, "INV_Gauntlets_26", "=q3=Bloodmail Gauntlets", "=ds=#s9#", "0.09%" },
        { 14614, "INV_Belt_23", "=q3=Bloodmail Belt", "=ds=#s10#", "0.60%" },
        { 14612, "INV_Pants_06", "=q3=Bloodmail Legguards", "=ds=#s11#", "0.42%" },
        { 14616, "INV_Boots_01", "=q3=Bloodmail Boots", "=ds=#s12#", "0.36%" },
        };

    ScholoPlate = {
        { 0, "INV_Box_01", "=q6=#pre60s9#", "=ec1= #a4#. =q1=#z5#" },
        { 14624, "INV_Chest_Chain_15", "=q3=Deathbone Chestplate", "=ds=#s5#", "0.45%" },
        { 14622, "INV_Gauntlets_28", "=q3=Deathbone Gauntlets", "=ds=#s9#", "0.45%" },
        { 14620, "INV_Belt_12", "=q3=Deathbone Girdle", "=ds=#s10#", "0.67%" },
        { 14623, "INV_Pants_04", "=q3=Deathbone Legguards", "=ds=#s11#", "1.12%" },
        { 14621, "INV_Boots_01", "=q3=Deathbone Sabatons", "=ds=#s12#", "0.57%" },
        };

    STRAT = {
        { 0, "INV_Box_01", "=q6=#pre60s10#", "=ec1=#a1#, =q2=#n24#. =q1=#z6#" },
        { 13390, "INV_Misc_Bandage_15", "=q3=The Postmaster's Band", "=ds=#s1#", "" },
        { 13388, "INV_Chest_Leather_10", "=q3=The Postmaster's Tunic", "=ds=#s5#", "" },
        { 13389, "INV_Pants_06", "=q3=The Postmaster's Trousers", "=ds=#s11#", "" },
        { 13391, "INV_Boots_02", "=q3=The Postmaster's Treads", "=ds=#s12#", "" },
        { 13392, "INV_Jewelry_Ring_23", "=q3=The Postmaster's Seal", "=ds=#s13#", "" },
        };

    ScourgeInvasion = {
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s11#", "=ec1=#a1#" },
        { 23085, "INV_Chest_Leather_06", "=q3=Tunic of Undead Slaying", "=ds=#s5#, =q2=#n25#", "" },
        { 23091, "INV_Bracer_12", "=q3=Bracers of Undead Cleansing", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23084, "INV_Gauntlets_16", "=q3=Gloves of Undead Cleansing", "=ds=#s9#, =q2=#m4#", "" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s12#", "=ec1=#a2#" },
        { 23089, "INV_Chest_Cloth_04", "=q3=Robe of Undead Cleansing", "=ds=#s5#, =q2=#n25#", "" },
        { 23093, "INV_Bracer_08", "=q3=Wristwraps of Undead Slaying", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23081, "INV_Gauntlets_06", "=q3=Handwraps of Undead Slaying", "=ds=#s9#, =q2=#m4#", "" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s13#", "=ec1=#a3#" },
        { 23088, "INV_Chest_Chain_08", "=q3=Chestguard of Undead Slaying", "=ds=#s5#, =q2=#n25#", "" },
        { 23092, "INV_Bracer_16", "=q3=Wristguards of Undead Slaying", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23082, "INV_Gauntlets_11", "=q3=Handguards of Undead Slaying", "=ds=#s9#, =q2=#m4#", "" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Talisman_13", "=q6=#pre60s14#", "=ec1=#a4#" },
        { 23087, "INV_Chest_Plate10", "=q3=Breastplate of Undead Slaying", "=ds=#s5#, =q2=#n25#", "" },
        { 23090, "INV_Bracer_14", "=q3=Bracers of Undead Slaying", "=ds=#s8#, =q2=#n26#, #n27#", "" },
        { 23078, "INV_Gauntlets_29", "=q3=Gauntlets of Undead Slaying", "=ds=#s9#, =q2=#m4#", "" },
        };

    ShardOfGods = {
        { 0, "INV_Box_01", "=q6=#pre60s15#", "=q1=#z7#" },
        { 17082, "INV_Misc_Orb_05", "=q4=Shard of the Flame", "=ds=#s14#, =q2=#n35# (#z14#)", "4.46%" }, 
        { 17064, "INV_Misc_MonsterScales_15", "=q4=Shard of the Scale", "=ds=#s14#, =q2=#n36# (#z15#)", "3.71%" }, 
        };

    ZGRings = {
        { 0, "INV_Box_01", "=q6=#pre60s16#", "=q1=#z8#" },
        { 19898, "INV_Jewelry_Ring_44", "=q3=Seal of Jin", "=ds=#s13#, =q2=#n28#", "8.81%" },
        { 19925, "INV_Jewelry_Ring_44", "=q3=Band of Jin", "=ds=#s13#, =q2=#n29#", "10.36%" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#pre60s17#", "=q1=#z8#" },
        { 19873, "INV_Jewelry_Ring_39", "=q3=Overlord's Crimson Band", "=ds=#s13#, =q2=#n33#", "10.12%" },
        { 19912, "INV_Jewelry_Ring_39", "=q3=Overlord's Onyx Band", "=ds=#s13#, =q2=#n30#", "14.51%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#pre60s18#", "=q1=#z8#" },
        { 19863, "INV_Jewelry_Ring_47", "=q3=Primalist's Seal", "=ds=#s13#, =q2=#n33#", "9.72%" },
        { 19920, "INV_Jewelry_Ring_47", "=q3=Primalist's Band", "=ds=#s13#, =q2=#n31#", "8.95%" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#pre60s19#", "=q1=#z8#" },
        { 19905, "INV_Jewelry_Ring_46", "=q3=Zanzil's Band", "=ds=#s13#, =q2=#n32#", "9.24%" },
        { 19893, "INV_Jewelry_Ring_46", "=q3=Zanzil's Seal", "=ds=#s13#, =q2=#n33#", "10.12%" },
        };

    SpiritofEskhandar = {
        { 0, "INV_Box_01", "=q6=#pre60s20#", "=q1=#z7#" },
        { 18204, "INV_Misc_Cape_07", "=q4=Eskhandar's Pelt", "=ds=#s4#, =q2=#n37#", "9.16%" },
        { 18205, "INV_Belt_12", "=q4=Eskhandar's Collar", "=ds=#s2#, =q2=#n36# (#z15#)", "14.29% " },
        { 18203, "INV_Misc_MonsterClaw_04", "=q4=Eskhandar's Right Claw", "=ds=#h3#, #w13#, =q2=#n38# (#z14#)", "16.97%" },
        { 18202, "INV_Misc_MonsterClaw_04", "=q4=Eskhandar's Left Claw", "=ds=#h4#, #w13#, =q2=#n39#", "12.36%" },
        };

    HakkariBlades = {
        { 0, "INV_Box_01", "=q6=#pre60s21#", "=q1=#z8#" },
        { 19865, "INV_Sword_55", "=q4=Warblade of the Hakkari", "=ds=#h3#, #w10#, =q2=#n34#", "5.18%" },
        { 19866, "INV_Sword_55", "=q4=Warblade of the Hakkari", "=ds=#h4#, #w10#, =q2=#n33#", "4.55%" },
        };

    PrimalBlessing = {
        { 0, "INV_Box_01", "=q6=#pre60s22#", "=q1=#z8#" },
        { 19896, "INV_Weapon_Hand_01", "=q4=Thekal's Grasp", "=ds=#h3#, #w13#, =q2=#n28#", "5.20%" },
        { 19910, "INV_Weapon_Hand_01", "=q4=Arlokk's Grasp", "=ds=#h4#, #w13#, =q2=#n30#", "4.54%" },
        };

    DalRend = {
        { 0, "INV_Box_01", "=q6=#pre60s23#", "=q1=#z9#" },
        { 12940, "INV_Sword_43", "=q3=Dal'Rend's Sacred Charge", "=ds=#h3#, #w10#, =q2=#n40#", "6.62%" },
        { 12939, "INV_Sword_40", "=q3=Dal'Rend's Tribal Guardian", "=ds=#h4#, #w10#, =q2=#n40#", "7.44%" },
        };

    SpiderKiss = {
        { 0, "INV_Box_01", "=q6=#pre60s24#", "=q1=#z10#" },
        { 13218, "INV_Weapon_ShortBlade_16", "=q3=Fang of the Crystal Spider", "=ds=#h1#, #w4#, =q2=#n41#", "15.46%" },
        { 13183, "INV_Weapon_Hand_01", "=q3=Venomspitter", "=ds=#h1#, #w6#, =q2=#n42#", "13.07%" },
        };

    TwinStars = {
        { 0, "INV_Box_01", "=q6=#bcs1#", "=q1=#z17#" },
        { 31338, "INV_Jewelry_Necklace_36", "=q4=Charlotte's Ivy", "=ds=#s2#", "0.01%" },
        { 31339, "INV_Jewelry_Ring_56", "=q4=Lola's Eve", "=ds=#s13#", "0.01%" },
        };

    AzzinothBlades = {
        { 0, "INV_Box_01", "=q6=#bcs2#", "=q1=#z18#" },
        { 32837, "INV_Weapon_Glave_01", "=q5=Warglaive of Azzinoth", "=ds=#h3#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 32838, "INV_Weapon_Glave_01", "=q5=Warglaive of Azzinoth", "=ds=#h4#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        };

-- Crafted Epic Weapons

    CraftedWeapons1 = {
        { 0, "INV_Box_01", "=q6=#p15#", "" },
        { 28425, "INV_Sword_1H_Blacksmithing_01", "=q4=Fireguard", "=ds=#h1#, #w10#" },
        { 28426, "INV_Sword_1H_Blacksmithing_02", "=q4=Blazeguard", "=ds=#h1#, #w10#" },
        { 28427, "INV_Sword_1H_Blacksmithing_03", "=q4=Blazefury", "=ds=#h1#, #w10#" },
        { 28428, "INV_Sword_2H_Blacksmithing_01", "=q4=Lionheart Blade", "=ds=#h2#, #w10#" },
        { 28429, "INV_Sword_2H_Blacksmithing_02", "=q4=Lionheart Champion", "=ds=#h2#, #w10#" },
        { 28430, "INV_Sword_2H_Blacksmithing_03", "=q4=Lionheart Executioner", "=ds=#h2#, #w10#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p14#", "" },
        { 28431, "INV_Axe_1H_BlackSmithing_01", "=q4=The Planar Edge", "=ds=#h3#, #w1#" },
        { 28432, "INV_Axe_1H_BlackSmithing_02", "=q4=Black Planar Edge", "=ds=#h3#, #w1#" },
        { 28433, "INV_Axe_1H_BlackSmithing_03", "=q4=Wicked Edge of the Planes", "=ds=#h3#, #w1#" },
        { 28434, "INV_Axe_50", "=q4=Lunar Crescent", "=ds=#h2#, #w1#" },
        { 28435, "INV_Axe_51", "=q4=Mooncleaver", "=ds=#h2#, #w1#" },
        { 28436, "INV_Axe_52", "=q4=Bloodmoon", "=ds=#h2#, #w1#" },
        { 0, "INV_Box_01", "=q6=#p22#", "" },
        { 28437, "INV_Mace_37", "=q4=Drakefist Hammer", "=ds=#h3#, #w6#" },
        { 28438, "INV_Mace_38", "=q4=Dragonmaw", "=ds=#h3#, #w6#" },
        { 28439, "INV_Mace_39", "=q4=Dragonstrike", "=ds=#h3#, #w6#" },
        { 28440, "INV_Mace_2H_Blacksmithing_01", "=q4=Thunder", "=ds=#h2#, #w6#" },
        { 28441, "INV_Mace_2H_Blacksmithing_02", "=q4=Deep Thunder", "=ds=#h2#, #w6#" },
        { 28442, "INV_Mace_2H_Blacksmithing_03", "=q4=Stormherald", "=ds=#h2#, #w6#" },
        };

    CraftedWeapons2 = {
        { 0, "INV_Box_01", "=q6=#p2#", "=q1=#j10#" },
        { 23554, "INV_Weapon_ShortBlade_05", "=q4=Eternium Runed Blade", "=ds=#h3#, #w4#" },
        { 23555, "INV_Weapon_ShortBlade_05", "=q4=Dirge", "=ds=#h1#, #w4#" },
        { 23540, "INV_Sword_59", "=q4=Felsteel Longblade", "=ds=#h1#, #w10#" },
        { 23541, "INV_Sword_08", "=q4=Khorium Champion", "=ds=#h2#, #w10#" },
        { 23542, "INV_Axe_15", "=q4=Fel Edged Battleaxe", "=ds=#h1#, #w1#" },
        { 23543, "INV_Axe_02", "=q4=Felsteel Reaper", "=ds=#h2#, #w1#" },
        { 23556, "INV_Mace_16", "=q4=Hand of Eternity", "=ds=#h3#, #w6#" },
        { 23544, "INV_Hammer_09", "=q4=Runic Hammer", "=ds=#h1#, #w6#" },
        { 23546, "INV_Hammer_17", "=q4=Fel Hardened Maul", "=ds=#h2#, #w6#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p5#", "=q1=#j10#" },
        { 32756, "INV_Weapon_Rifle_13", "=q4=Gyro-balanced Khorium Destroyer", "=ds=#w5#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p2#", "=q1=#j9#" },
        { 19166, "INV_Weapon_ShortBlade_12", "=q4=Black Amnesty", "=ds=#h1#, #w4#" },
        { 22383, "INV_Sword_51", "=q4=Sageblade", "=ds=#h3#, #w10#" },
        { 19168, "INV_Sword_39", "=q4=Blackguard", "=ds=#h1#, #w10#" },
        { 19169, "INV_Axe_12", "=q4=Nightfall", "=ds=#h2#, #w1#" },
        { 22384, "INV_Hammer_08", "=q4=Persuader", "=ds=#h3#, #w6#" },
        { 19170, "INV_Hammer_19", "=q4=Ebon Hand", "=ds=#h1#, #w6#" },
        { 17193, "INV_Hammer_Unique_Sulfuras", "=q4=Sulfuron Hammer", "=ds=#h2#, #w6#" },
        { 19167, "INV_Spear_08", "=q4=Blackfury", "=ds=#w7#" },
        { 22198, "INV_Shield_22", "=q4=Jagged Obsidian Shield", "=ds=#w8#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#p5#", "=q1=#j9#" },
        { 18282, "INV_Weapon_Rifle_05", "=q4=Core Marksman Rifle", "=ds=#w5#" },
        { 18168, "Spell_Arcane_PortalDarnassus", "=q4=Force Reactive Disk", "=ds=#w8#" },
        };

-- Blacksmithing Plate Sets

    ImperialPlate = {
        { 0, "INV_Hammer_20", "=q6=#craftbp1#", "" },
        { 12427, "INV_Helmet_22", "=q2=Imperial Plate Helm", "=ds=#s1#, #a4#" },
        { 12428, "INV_Shoulder_02", "=q2=Imperial Plate Shoulders", "=ds=#s3#, #a4#" },
        { 12422, "INV_Chest_Plate10", "=q2=Imperial Plate Chest", "=ds=#s5#, #a4#" },
        { 12425, "INV_Bracer_19", "=q2=Imperial Plate Bracers", "=ds=#s8#, #a4#" },
        { 12424, "INV_Belt_01", "=q2=Imperial Plate Belt", "=ds=#s10#, #a4#" },
        { 12429, "INV_Pants_04", "=q2=Imperial Plate Leggings", "=ds=#s11#, #a4#" },
        { 12426, "INV_Boots_Plate_01", "=q2=Imperial Plate Boots", "=ds=#s12#, #a4#" },
        };

    TheDarksoul = {
        { 0, "INV_Hammer_20", "=q6=#craftbp2#", "" },
        { 19695, "INV_Shoulder_01", "=q3=Darksoul Shoulders", "=ds=#s3#, #a4#" },
        { 19693, "INV_Chest_Plate08", "=q3=Darksoul Breastplate", "=ds=#s5#, #a4#" },
        { 19694, "INV_Pants_Plate_21", "=q3=Darksoul Leggings", "=ds=#s11#, #a4#" },
        };   

    FelIronPlate = {
        { 0, "INV_Hammer_20", "=q6=#craftbp3#", "" },
        { 23489, "INV_Chest_Plate07", "=q2=Fel Iron Breastplate", "=ds=#s5#, #a4#" },
        { 23482, "INV_Gauntlets_03", "=q2=Fel Iron Plate Gloves", "=ds=#s9#, #a4#" },
        { 23484, "INV_Belt_21", "=q2=Fel Iron Plate Belt", "=ds=#s10#, #a4#" },
        { 23488, "INV_Pants_Plate_18", "=q2=Fel Iron Plate Pants", "=ds=#s11#, #a4#" },
        { 23487, "INV_Boots_Chain_11", "=q2=Fel Iron Plate Boots", "=ds=#s12#, #a4#" },
        };

    AdamantiteB = {
        { 0, "INV_Hammer_20", "=q6=#craftbp4#","" },
        { 23507, "INV_Chest_Plate11", "=q3=Adamantite Breastplate", "=ds=#s5#, #a4#" },
        { 23506, "INV_Bracer_07", "=q3=Adamantite Plate Bracers", "=ds=#s8#, #a4#" },
        { 23508, "INV_Gauntlets_30", "=q3=Adamantite Plate Gloves", "=ds=#s9#, #a4#" },
        };

    FlameG = {
        { 0, "INV_Hammer_20", "=q6=#craftbp5#", "=q1=#j11#" },
        { 23516, "INV_Helmet_22", "=q3=Flamebane Helm", "=ds=#s1#, #a4#" },
        { 23513, "INV_Chest_Plate16", "=q3=Flamebane Breastplate", "=ds=#s5#, #a4#" },
        { 23515, "INV_Bracer_19", "=q3=Flamebane Bracers", "=ds=#s8#, #a4#" },
        { 23514, "INV_Gauntlets_11", "=q3=Flamebane Gloves", "=ds=#s9#, #a4#" },
        };   

    EnchantedAdaman = {
        { 0, "INV_Hammer_20", "=q6=#craftbp6#", "=q1=#j12#" },
        { 23509, "INV_Chest_Plate10", "=q3=Enchanted Adamantite Breastplate", "=ds=#s5#, #a4#" },
        { 23510, "INV_Belt_29", "=q3=Enchanted Adamantite Belt", "=ds=#s10#, #a4#" },
        { 23512, "INV_Pants_Plate_12", "=q3=Enchanted Adamantite Leggings", "=ds=#s11#, #a4#" },
        { 23511, "INV_Boots_Chain_08", "=q3=Enchanted Adamantite Boots", "=ds=#s12#, #a4#" },
        };

    KhoriumWard = {
        { 0, "INV_Hammer_20", "=q6=#craftbp7#", "" },
        { 23524, "INV_Belt_11", "=q3=Khorium Belt", "=ds=#s10#, #a4#" },
        { 23523, "INV_Pants_Plate_04", "=q3=Khorium Pants", "=ds=#s11#, #a4#" },
        { 23525, "INV_Boots_Chain_01", "=q3=Khorium Boots", "=ds=#s12#, #a4#" },
        };
         
    FaithFelsteel = { 
        { 0, "INV_Hammer_20", "=q6=#craftbp8#", "" },
        { 23519, "INV_Helmet_22", "=q3=Felsteel Helm", "=ds=#s1#, #a4#" },
        { 23517, "INV_Gauntlets_29", "=q3=Felsteel Gloves", "=ds=#s9#, #a4#" },
        { 23518, "INV_Pants_Plate_06", "=q3=Felsteel Leggings", "=ds=#s11#, #a4#" },
        };

    BurningRage = { 
        { 0, "INV_Hammer_20", "=q6=#craftbp9#", "" },
        { 23521, "INV_Helmet_22", "=q3=Ragesteel Helm", "=ds=#s1#, #a4#" },
        { 23522, "INV_Chest_Chain_16", "=q3=Ragesteel Breastplate", "=ds=#s5#, #a4#" },
        { 23520, "INV_Gauntlets_26", "=q3=Ragesteel Gloves", "=ds=#s9#, #a4#" },
        };

-- Blacksmithing Mail Sets

    BloodsoulEmbrace = {
        { 0, "INV_Hammer_20", "=q6=#craftbm1#", "" },
        { 19691, "INV_Shoulder_15", "=q3=Bloodsoul Shoulders", "=ds=#s3#, #a3#" },
        { 19690, "INV_Chest_Chain_14", "=q3=Bloodsoul Breastplate", "=ds=#s5#, #a3#" },
        { 19692, "INV_Gauntlets_31", "=q3=Bloodsoul Gauntlets", "=ds=#s9#, #a3#" },
        };

    FelIronChain = {
        { 0, "INV_Hammer_20", "=q6=#craftbm2#", "" },
        { 23493, "INV_Helmet_35", "=q2=Fel Iron Chain Coif", "=ds=#s1#, #a3#" },
        { 23490, "INV_Chest_Chain_14", "=q2=Fel Iron Chain Tunic", "=ds=#s5#, #a3#" },
        { 23494, "INV_Bracer_13", "=q2=Fel Iron Chain Bracers", "=ds=#s8#, #a3#" },
        { 23491, "INV_Gauntlets_11", "=q2=Fel Iron Chain Gloves", "=ds=#s9#, #a3#" },
        };

-- Tailoring Sets
           
    BloodvineG = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt1#", "" },
        { 19682, "INV_Chest_Cloth_07", "=q3=Bloodvine Vest", "=ds=#s5#, #a1#" },
        { 19683, "INV_Pants_Cloth_14", "=q3=Bloodvine Leggings", "=ds=#s11#, #a1#" },
        { 19684, "INV_Boots_Cloth_02","=q3=Bloodvine Boots", "=ds=#s12#, #a1#" },
        };
 
    NeatherVest = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt2#", "" },
        { 21855, "INV_Shirt_04", "=q2=Netherweave Tunic", "=ds=#s5#, #a1#" },
        { 21854, "INV_Chest_Cloth_29", "=q2=Netherweave Robe", "=ds=#s5#, #a1#" }, 
        { 21849, "INV_Bracer_07", "=q2=Netherweave Bracers", "=ds=#s8#, #a1#" },
        { 21851, "INV_Gauntlets_27", "=q2=Netherweave Gloves", "=ds=#s9#, #a1##" },
        { 21850, "INV_Belt_04", "=q2=Netherweave Belt", "=ds=#s10#, #a1#" },
        { 21852, "INV_Pants_09", "=q2=Netherweave Pants", "=ds=#s11#, #a1#" },
        { 21853, "INV_Boots_05","=q2=Netherweave Boots", "=ds=#s12#, #a1#" },  
        };  

    ImbuedNeather = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt3#", "" },
        { 21862, "INV_Chest_Cloth_45", "=q3=Imbued Netherweave Tunic", "=ds=#s5#, #a1#" },
        { 21861, "INV_Chest_Cloth_12", "=q3=Imbued Netherweave Robe", "=ds=#s5#, #a1#" }, 
        { 21859, "INV_Pants_Leather_09", "=q3=Imbued Netherweave Pants", "=ds=#s11#, #a1#" },
        { 21860, "INV_Boots_07","=q3=Imbued Netherweave Boots", "=ds=#s12#, #a1#" },   
        };  
  
    ArcanoVest = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt4#", "=q1=#j12#" },
        { 21868, "INV_Chest_Cloth_01", "=q3=Arcanoweave Robe", "=ds=#s5#, #a1#" },
        { 21866, "INV_Bracer_19", "=q3=Arcanoweave Bracers", "=ds=#s8#, #a1#" },  
        { 21867, "INV_Boots_07","=q3=Arcanoweave Boots", "=ds=#s12#, #a1#" },  
        };

    TheUnyielding = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt5#", "" },
        { 24249, "INV_Bracer_11", "=q3=Unyielding Bracers", "=ds=#s8#, #a1#" },
        { 24255, "INV_Belt_03", "=q4=Unyielding Girdle", "=ds=#s10#, #a1#" }, 
        };

    WhitemendWis = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt6#", "" },
        { 24264, "INV_Helmet_53", "=q4=Whitemend Hood", "=ds=#s1#, #a1#" },  
        { 24261, "INV_Pants_Cloth_07", "=q4=Whitemend Pants", "=ds=#s11#, #a1#" },
        };

    SpellstrikeInfu = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt7#", "" },
        { 24266, "INV_Helmet_27", "=q4=Spellstrike Hood", "=ds=#s1#, #a1#" },  
        { 24262, "INV_Pants_Cloth_14", "=q4=Spellstrike Pants", "=ds=#s11#, #a1#" },   
        };

    BattlecastG = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt8#", "" },
        { 24267, "INV_Helmet_70", "=q4=Battlecast Hood", "=ds=#s1#, #a1#" },  
        { 24263, "INV_Pants_Cloth_12", "=q4=Battlecast Pants", "=ds=#s11#, #a1#" },  
        };

    SoulclothEm = {
        { 0, "INV_Fabric_Linen_02", "=q6=#craftt9#", "=q1=#j12#" },
        { 21864, "INV_Shoulder_02", "=q4=Soulcloth Shoulders", "=ds=#s3#, #a1#" },
        { 21865, "INV_Chest_Cloth_12", "=q4=Soulcloth Vest", "=ds=#s5#, #a1#" },  
        { 21863, "INV_Gauntlets_17", "=q4=Soulcloth Gloves", "=ds=#s9#, #a1#" },  
        };      

    PrimalMoon = {
        { 0, "INV_Fabric_Linen_02", "=q6=#crafttm1#", "=q1=#p19#" }, 
        { 21874, "INV_Shoulder_02", "=q4=Primal Mooncloth Shoulders", "=ds=#s3#, #a1#" }, 
        { 21875, "INV_Chest_Cloth_04", "=q4=Primal Mooncloth Robe", "=ds=#s5#, #a1#" },  
        { 21873, "INV_Belt_31", "=q4=Primal Mooncloth Belt", "=ds=#s10#, #a1#" },
        };  
  
    ShadowEmbrace = {
        { 0, "INV_Fabric_Linen_02", "=q6=#crafttsh1#", "=q1=#p20#" }, 
        { 21869, "INV_Shoulder_25", "=q4=Frozen Shadoweave Shoulders", "=ds=#s3#, #a1#" },
        { 21871, "INV_Chest_Cloth_08", "=q4=Frozen Shadoweave Vest", "=ds=#s5#, #a1#" },  
        { 21870, "INV_Boots_Cloth_03","=q4=Frozen Shadoweave Boots", "=ds=#s12#, #a1#" },
        };      
  
    SpellfireWrath = {
        { 0, "INV_Fabric_Linen_02", "=q6=#crafttsf1#", "=q1=#p21#" },  
        { 21848, "INV_Chest_Cloth_02", "=q3=Spellfire Vest", "=ds=#s5#, #a1#" },
        { 21847, "INV_Gauntlets_19", "=q3=Spellfire Gloves", "=ds=#s9#, #a1#" },
        { 21846, "INV_Belt_04", "=q3=Spellfire Belt", "=ds=#s10#, #a1#" },  
        };      

-- Leatherworking Leather Sets
        
    VolcanicArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl1#", "=q1=#j11#" },
        { 15055, "INV_Shoulder_13", "=q2=Volcanic Shoulders", "=ds=#s3#, #a2#" },
        { 15053, "INV_Chest_Leather_07", "=q2=Volcanic Breastplate", "=ds=#s5#, #a2#" },
        { 15054, "INV_Pants_06", "=q2=Volcanic Leggings", "=ds=#s11#, #a2#" },
        }; 
 
    IronfeatherArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl2#", "" },
        { 15067, "INV_Shoulder_06", "=q3=Ironfeather Shoulders", "=ds=#s3#, #a2#" },
        { 15066, "INV_Chest_Leather_06", "=q3=Ironfeather Breastplate", "=ds=#s5#, #a2#" },
        };

    StormshroudArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl3#", "" },
        { 15058, "INV_Shoulder_05", "=q3=Stormshroud Shoulders", "=ds=#s3#, #a2#" },
        { 15056, "INV_Chest_Leather_08", "=q3=Stormshroud Armor", "=ds=#s5#, #a2#" },
        { 21278, "INV_Gauntlets_05", "=q3=Stormshroud Gloves", "=ds=#s9#, #a2#" },
        { 15057, "INV_Pants_09", "=q3=Stormshroud Pants", "=ds=#s11#, #a2#" },
        };

    DevilsaurArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwl4#", "" },
        { 15063, "INV_Gauntlets_26", "=q3=Devilsaur Gauntlets", "=ds=#s9#, #a2#" },
        { 15062, "INV_Pants_Wolf", "=q3=Devilsaur Leggings", "=ds=#s11#, #a2#" },
        };


    BloodTigerH = {
        { 0, "INV_Box_01", "=q6=#craftlwl5#", "" },
        { 19689, "INV_Shoulder_23", "=q3=Blood Tiger Shoulders", "=ds=#s3#, #a2#" },
        { 19688, "INV_Chest_Leather_07", "=q3=Blood Tiger Breastplate", "=ds=#s5#, #a2#" },
        };
  
    PrimalBatskin = {
        { 0, "INV_Box_01", "=q6=#craftlwl6#", "" },
        { 19685, "INV_Chest_Leather_03", "=q3=Primal Batskin Jerkin", "=ds=#s5#, #a2#" },
        { 19687, "INV_Bracer_07", "=q3=Primal Batskin Bracers", "=ds=#s8#, #a2#" },
        { 19686, "INV_Gauntlets_31", "=q3=Primal Batskin Gloves", "=ds=#s9#, #a2#" },
        };    

    WildDraenishA = {
        { 0, "INV_Box_01", "=q6=#craftlwl7#", "" },
        { 25676, "INV_Chest_Leather_07", "=q2=Wild Draenish Vest", "=ds=#s5#, #a2#" },
        { 25674, "INV_Gauntlets_04", "=q2=Wild Draenish Gloves", "=ds=#s9#, #a2#" },
        { 25675, "INV_Pants_Leather_07", "=q2=Wild Draenish Leggings", "=ds=#s11#, #a2#" },
        { 25673, "INV_Boots_Chain_01", "=q2=Wild Draenish Boots", "=ds=#s12#, #a2#" },
        };
  
    ThickDraenicA = {
        { 0, "INV_Box_01", "=q6=#craftlwl8#", "" },
        { 25671, "INV_Chest_Leather_07", "=q2=Thick Draenic Vest", "=ds=#s5#, #a2#" },
        { 25669, "INV_Gauntlets_04", "=q2=Thick Draenic Gloves", "=ds=#s9#, #a2#" },
        { 25670, "INV_Pants_Leather_07", "=q2=Thick Draenic Pants", "=ds=#s11#, #a2#" },
        { 25668, "INV_Boots_Chain_01", "=q2=Thick Draenic Boots", "=ds=#s12#, #a2#" },
        };  

    FelSkin = {
        { 0, "INV_Box_01", "=q6=#craftlwl9#", "" },
        { 25685, "INV_Gauntlets_22", "=q3=Fel Leather Gloves", "=ds=#s9#, #a2#" },
        { 25687, "INV_Pants_Leather_03", "=q3=Fel Leather Leggings", "=ds=#s11#, #a2#" },
        { 25686, "INV_Boots_Cloth_05", "=q3=Fel Leather Boots", "=ds=#s12#, #a2#" },
        };
  
    SClefthoof = {
        { 0, "INV_Box_01", "=q6=#craftlwl10#", "" },
        { 25689, "INV_Chest_Leather_06", "=q3=Heavy Clefthoof Vest", "=ds=#s5#, #a2#" },
        { 25690, "INV_Pants_12", "=q3=Heavy Clefthoof Leggings", "=ds=#s11#, #a2#" },
        { 25691, "INV_Boots_07", "=q3=Heavy Clefthoof Boots", "=ds=#s12#, #a2#" },
        };

-- Leatherworking Mail Sets

    GreenDragonM = {
        { 0, "INV_Box_01", "=q6=#craftlwm1#", "=q1=#j13#" },
        { 15045, "INV_Chest_Chain_06", "=q3=Green Dragonscale Breastplate", "=ds=#s5#, #a3#" },
        { 20296, "INV_Gauntlets_12", "=q3=Green Dragonscale Gauntlets", "=ds=#s9#, #a3#" },
        { 15046, "INV_Pants_05", "=q3=Green Dragonscale Leggings", "=ds=#s11#, #a3#" },
        };

    BlueDragonM = {
        { 0, "INV_Box_01", "=q6=#craftlwm2#", "=q1=#j12#" },
        { 15049, "INV_Shoulder_18", "=q3=Blue Dragonscale Shoulders", "=ds=#s3#, #a3#" },
        { 15048, "INV_Chest_Chain_04", "=q3=Blue Dragonscale Breastplate", "=ds=#s5#, #a3#" },
        { 20295, "INV_Pants_Mail_15", "=q3=Blue Dragonscale Leggings", "=ds=#s11#, #a3#" },
        }; 

    BlackDragonM = {
        { 0, "INV_Box_01", "=q6=#craftlwm3#", "=q1=#j11#" },
        { 15051, "INV_Shoulder_01", "=q3=Black Dragonscale Shoulders", "=ds=#s3#, #a3#" },
        { 15050, "INV_Chest_Plate06", "=q3=Black Dragonscale Breastplate", "=ds=#s5#, #a3#" },
        { 15052, "INV_Pants_03", "=q3=Black Dragonscale Leggings", "=ds=#s11#, #a3#" },
        { 16984, "INV_Boots_Plate_09","=q4=Black Dragonscale Boots", "=ds=#s12#, #a3#" },
        };

    ScaledDraenicA = {
        { 0, "INV_Box_01", "=q6=#craftlwm4#", "" },
        { 25660, "INV_Chest_Chain_16", "=q2=Scaled Draenic Vest", "=ds=#s5#, #a3#" },
        { 25661, "INV_Gauntlets_04", "=q2=Scaled Draenic Gloves", "=ds=#s9#, #a3#" },
        { 25662, "INV_Pants_Mail_07", "=q2=Scaled Draenic Pants", "=ds=#s11#, #a3#" },
        { 25659, "INV_Boots_Chain_01", "=q2=Scaled Draenic Boots", "=ds=#s12#, #a3#" },
        };    

    FelscaleArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwm5#", "" },
        { 25657, "INV_Chest_Chain_13", "=q2=Felscale Breastplate", "=ds=#s5#, #a3#" },
        { 25654, "INV_Gauntlets_04", "=q2=Felscale Gloves", "=ds=#s9#, #a3#" },
        { 25656, "INV_Pants_Mail_08", "=q2=Felscale Pants", "=ds=#s11#, #a3#" },
        { 25655, "INV_Boots_Chain_08", "=q2=Felscale Boots", "=ds=#s12#, #a3#" },
        };    

    FelstalkerArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwm6#", "" },
        { 25696, "INV_Chest_Chain_13", "=q3=Felstalker Breastplate", "=ds=#s5#, #a3#" },
        { 25697, "INV_Bracer_14", "=q3=Felstalker Bracers", "=ds=#s8#, #a3#" },
        { 25695, "INV_Belt_13", "=q3=Felstalker Belt", "=ds=#s10#, #a3#" },
        };

    NetherFury = {
        { 0, "INV_Box_01", "=q6=#craftlwm7#", "" },
        { 25694, "INV_Belt_15", "=q3=Netherfury Belt", "=ds=#s10#, #a3#" },
        { 25692, "INV_Pants_Plate_12", "=q3=Netherfury Leggings", "=ds=#s11#, #a3#" },
        { 25693, "INV_Boots_Chain_06", "=q3=Netherfury Boots", "=ds=#s12#, #a3#" },
        };  

    PrimalIntent = {
        { 0, "INV_Box_01", "=q6=#craftlwe1#", "=q1=#p11#" },
        { 29525, "INV_Chest_Cloth_45", "=q4=Primalstrike Vest", "=ds=#s5#, #a2#" },
        { 29527, "INV_Bracer_07", "=q4=Primalstrike Bracers", "=ds=#s8#, #a2#" },
        { 29526, "INV_Belt_03", "=q4=Primalstrike Belt", "=ds=#s10#, #a2#" },
        };

    WindhawkArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwt1#", "=q1=#p10#" },
        { 29522, "INV_Chest_Leather_01", "=q4=Windhawk Hauberk", "=ds=#s5#, #a2#" },
        { 29523, "INV_Bracer_07", "=q4=Windhawk Bracers", "=ds=#s8#, #a2#" },
        { 29524, "INV_Belt_03", "=q4=Windhawk Belt", "=ds=#s10#, #a2#" },
        };

    NetherscaleArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwd1#", "=q1=#p9#" },
        { 29515, "INV_Chest_Plate08", "=q4=Ebon Netherscale Breastplate", "=ds=#s5#, #a3#" },
        { 29517, "INV_Bracer_19", "=q4=Ebon Netherscale Bracers", "=ds=#s8#, #a3#" },
        { 29516, "INV_Belt_29", "=q4=Ebon Netherscale Belt", "=ds=#s10#, #a3#" },
        };
  
    NetherstrikeArmor = {
        { 0, "INV_Box_01", "=q6=#craftlwd2#", "=q1=#p9#" },
        { 29519, "INV_Chest_Plate07", "=q4=Netherstrike Breastplate", "=ds=#s5#, #a3#" },
        { 29521, "INV_Bracer_12", "=q4=Netherstrike Bracers", "=ds=#s8#, #a3#" },
        { 29520, "INV_Belt_03", "=q4=Netherstrike Belt", "=ds=#s10#, #a3#" },
        };

-- Arena Season 1 Sets
 
    ArenaDruid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#arenas1_1#", "" },
        { 28127, "INV_Helmet_30", "=q4=Gladiator's Dragonhide Helm", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 28129, "INV_Shoulder_12", "=q4=Gladiator's Dragonhide Spaulders", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 28130, "INV_Chest_Leather_03", "=q4=Gladiator's Dragonhide Tunic", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 28126, "INV_Gauntlets_28", "=q4=Gladiator's Dragonhide Gloves", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 28128, "INV_Pants_Cloth_05", "=q4=Gladiator's Dragonhide Legguards", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arenas1_2#", "" },
        { 28137, "INV_Helmet_30", "=q4=Gladiator's Wyrmhide Helm", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 28139, "INV_Shoulder_12", "=q4=Gladiator's Wyrmhide Spaulders", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 28140, "INV_Chest_Leather_03", "=q4=Gladiator's Wyrmhide Tunic", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 28136, "INV_Gauntlets_28", "=q4=Gladiator's Wyrmhide Gloves", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 28138, "INV_Pants_Cloth_05", "=q4=Gladiator's Wyrmhide Legguards", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arenas1_3#", "" },
        { 31376, "INV_Helmet_30", "=q4=Gladiator's Kodohide Helm", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 31378, "INV_Shoulder_12", "=q4=Gladiator's Kodohide Spaulders", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 31379, "INV_Chest_Leather_03", "=q4=Gladiator's Kodohide Tunic", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 31375, "INV_Gauntlets_28", "=q4=Gladiator's Kodohide Gloves", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 31377, "INV_Pants_Cloth_05", "=q4=Gladiator's Kodohide Legguards", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        };

    ArenaHunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#arenas2#", "" },
        { 28331, "INV_Helmet_09", "=q4=Gladiator's Chain Helm", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 28333, "INV_Shoulder_29", "=q4=Gladiator's Chain Spaulders", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 28334, "INV_Chest_Chain_11", "=q4=Gladiator's Chain Armor", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 28335, "INV_Gauntlets_11", "=q4=Gladiator's Chain Gauntlets", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 28332, "INV_Pants_Mail_15", "=q4=Gladiator's Chain Leggings", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        };
        
    ArenaMage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#arenas3#", "" },
        { 25855, "INV_Helmet_08", "=q4=Gladiator's Silk Cowl", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 25854, "INV_Shoulder_19", "=q4=Gladiator's Silk Amice", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 25856, "INV_Chest_Leather_01", "=q4=Gladiator's Silk Raiment", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 25857, "INV_Gauntlets_19", "=q4=Gladiator's Silk Handguards", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 25858, "INV_Pants_07", "=q4=Gladiator's Silk Trousers", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        };
        
    ArenaPaladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#arenas4_1#", "" },
        { 27704, "INV_Helmet_22", "=q4=Gladiator's Lamellar Helm", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 27706, "INV_Shoulder_22", "=q4=Gladiator's Lamellar Shoulders", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 27702, "INV_Chest_Plate05", "=q4=Gladiator's Lamellar Chestpiece", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 27703, "INV_Gauntlets_29", "=q4=Gladiator's Lamellar Gauntlets", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 27705, "INV_Pants_Plate_17", "=q4=Gladiator's Lamellar Legguards", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arenas4_2#", "" },
        { 27881, "INV_Helmet_22", "=q4=Gladiator's Scaled Helm", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 27883, "INV_Shoulder_22", "=q4=Gladiator's Scaled Shoulders", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 27879, "INV_Chest_Plate05", "=q4=Gladiator's Scaled Chestpiece", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 27880, "INV_Gauntlets_29", "=q4=Gladiator's Scaled Gauntlets", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 27882, "INV_Pants_Plate_17", "=q4=Gladiator's Scaled Legguards", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arenas4_3#", "" },
        { 31616, "INV_Helmet_22", "=q4=Gladiator's Ornamented Headcover", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 31619, "INV_Shoulder_22", "=q4=Gladiator's Ornamented Spaulders", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 31613, "INV_Chest_Plate05", "=q4=Gladiator's Ornamented Chestguard", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 31614, "INV_Gauntlets_29", "=q4=Gladiator's Ornamented Gloves", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 31618, "INV_Pants_Plate_17", "=q4=Gladiator's Ornamented Legplates", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        };

    ArenaPriest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arenas5_1#", "" },
        { 27708, "INV_Helmet_30", "=q4=Gladiator's Satin Hood", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 27710, "INV_Shoulder_02", "=q4=Gladiator's Satin Mantle", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 27711, "INV_Chest_Cloth_43", "=q4=Gladiator's Satin Robe", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 27707, "INV_Gauntlets_15", "=q4=Gladiator's Satin Gloves", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 27709, "INV_Pants_Cloth_05", "=q4=Gladiator's Satin Leggings", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arenas5_2#", "" },
        { 31410, "INV_Helmet_30", "=q4=Gladiator's Mooncloth Hood", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 31412, "INV_Shoulder_02", "=q4=Gladiator's Mooncloth Mantle", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 31413, "INV_Chest_Cloth_43", "=q4=Gladiator's Mooncloth Robe", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 31409, "INV_Gauntlets_15", "=q4=Gladiator's Mooncloth Gloves", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 31411, "INV_Pants_Cloth_05", "=q4=Gladiator's Mooncloth Leggings", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        };

    ArenaRogue = {
        { 0, "Ability_BackStab", "=q6=#arenas6#", "" },
        { 25830, "INV_Helmet_30", "=q4=Gladiator's Leather Helm", "=ds=#a2#, #s1#", "", "1630", "#arena#" },
        { 25832, "INV_Shoulder_12", "=q4=Gladiator's Leather Spaulders", "=ds=#a2#, #s3#", "", "1304", "#arena#" },
        { 25831, "INV_Chest_Leather_03", "=q4=Gladiator's Leather Tunic", "=ds=#a2#, #s5#", "", "1630", "#arena#" },
        { 25834, "INV_Gauntlets_28", "=q4=Gladiator's Leather Gloves", "=ds=#a2#, #s9#", "", "978", "#arena#" },
        { 25833, "INV_Pants_Cloth_05", "=q4=Gladiator's Leather Legguards", "=ds=#a2#, #s11#", "", "1630", "#arena#" },
        };

    ArenaShaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arenas7_1#", "" },
        { 25998, "INV_Helmet_09", "=q4=Gladiator's Linked Helm", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 25999, "INV_Shoulder_29", "=q4=Gladiator's Linked Spaulders", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 25997, "INV_Chest_Chain_11", "=q4=Gladiator's Linked Armor", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 26000, "INV_Gauntlets_11", "=q4=Gladiator's Linked Gauntlets", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 26001, "INV_Pants_Mail_15", "=q4=Gladiator's Linked Leggings", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arenas7_2#", "" },
        { 27471, "INV_Helmet_09", "=q4=Gladiator's Mail Helm", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 27473, "INV_Shoulder_29", "=q4=Gladiator's Mail Spaulders", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 27469, "INV_Chest_Chain_11", "=q4=Gladiator's Mail Armor", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 27470, "INV_Gauntlets_11", "=q4=Gladiator's Mail Gauntlets", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 27472, "INV_Pants_Mail_15", "=q4=Gladiator's Mail Leggings", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arenas7_3#", "" },
        { 31400, "INV_Helmet_09", "=q4=Gladiator's Ringmail Helm", "=ds=#a3#, #s1#", "", "1630", "#arena#" },
        { 31407, "INV_Shoulder_29", "=q4=Gladiator's Ringmail Spaulders", "=ds=#a3#, #s3#", "", "1304", "#arena#" },
        { 31396, "INV_Chest_Chain_11", "=q4=Gladiator's Ringmail Armor", "=ds=#a3#, #s5#", "", "1630", "#arena#" },
        { 31397, "INV_Gauntlets_11", "=q4=Gladiator's Ringmail Gauntlets", "=ds=#a3#, #s9#", "", "978", "#arena#" },
        { 31406, "INV_Pants_Mail_15", "=q4=Gladiator's Ringmail Leggings", "=ds=#a3#, #s11#", "", "1630", "#arena#" },
        };

    ArenaWarlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arenas8_1#", "" },
        { 24553, "INV_Helmet_30", "=q4=Gladiator's Dreadweave Hood", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 24554, "INV_Shoulder_02", "=q4=Gladiator's Dreadweave Mantle", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 24552, "INV_Chest_Cloth_43", "=q4=Gladiator's Dreadweave Robe", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 24556, "INV_Gauntlets_15", "=q4=Gladiator's Dreadweave Gloves", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 24555, "INV_Pants_Cloth_05", "=q4=Gladiator's Dreadweave Leggings", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arenas8_2#", "" },
        { 30187, "INV_Helmet_08", "=q4=Gladiator's Felweave Cowl", "=ds=#a1#, #s1#", "", "1630", "#arena#" },
        { 30186, "INV_Shoulder_19", "=q4=Gladiator's Felweave Amice", "=ds=#a1#, #s3#", "", "1304", "#arena#" },
        { 30200, "INV_Chest_Leather_01", "=q4=Gladiator's Felweave Raiment", "=ds=#a1#, #s5#", "", "1630", "#arena#" },
        { 30188, "INV_Gauntlets_19", "=q4=Gladiator's Felweave Handguards", "=ds=#a1#, #s9#", "", "978", "#arena#" },
        { 30201, "INV_Pants_07", "=q4=Gladiator's Felweave Trousers", "=ds=#a1#, #s11#", "", "1630", "#arena#" },
        };
                
    ArenaWarrior = {
        { 0, "INV_Shield_05", "=q6=#arenas9#", "" },
        { 24545, "INV_Helmet_07", "=q4=Gladiator's Plate Helm", "=ds=#a4#, #s1#", "", "1630", "#arena#" },
        { 24546, "INV_Shoulder_22", "=q4=Gladiator's Plate Shoulders", "=ds=#a4#, #s3#", "", "1304", "#arena#" },
        { 24544, "INV_Chest_Plate05", "=q4=Gladiator's Plate Chestpiece", "=ds=#a4#, #s5#", "", "1630", "#arena#" },
        { 24549, "INV_Gauntlets_29", "=q4=Gladiator's Plate Gauntlets", "=ds=#a4#, #s9#", "", "978", "#arena#" },
        { 24547, "INV_Pants_Plate_17", "=q4=Gladiator's Plate Legguards", "=ds=#a4#, #s11#", "", "1630", "#arena#" },
        };

-- Arena Season 2 Sets
        
    Arena2Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#arena2s1_1#", "" },
        { 31968, "INV_Helmet_30", "=q4=Merciless Gladiator's Dragonhide Helm", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 31971, "INV_Shoulder_12", "=q4=Merciless Gladiator's Dragonhide Spaulders", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 31972, "INV_Chest_Leather_03", "=q4=Merciless Gladiator's Dragonhide Tunic", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 31967, "INV_Gauntlets_28", "=q4=Merciless Gladiator's Dragonhide Gloves", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 31969, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Dragonhide Legguards", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arena2s1_2#", "" },
        { 32057, "INV_Helmet_30", "=q4=Merciless Gladiator's Wyrmhide Helm", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 32059, "INV_Shoulder_12", "=q4=Merciless Gladiator's Wyrmhide Spaulders", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 32060, "INV_Chest_Leather_03", "=q4=Merciless Gladiator's Wyrmhide Tunic", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 32056, "INV_Gauntlets_28", "=q4=Merciless Gladiator's Wyrmhide Gloves", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 32058, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Wyrmhide Legguards", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#arena2s1_3#", "" },
        { 31988, "INV_Helmet_30", "=q4=Merciless Gladiator's Kodohide Helm", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 31990, "INV_Shoulder_12", "=q4=Merciless Gladiator's Kodohide Spaulders", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 31991, "INV_Chest_Leather_03", "=q4=Merciless Gladiator's Kodohide Tunic", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 31987, "INV_Gauntlets_28", "=q4=Merciless Gladiator's Kodohide Gloves", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 31989, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Kodohide Legguards", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        };
       
    Arena2Hunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#arena2s2#", "" },
        { 31962, "INV_Helmet_09", "=q4=Merciless Gladiator's Chain Helm", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 31964, "INV_Shoulder_29", "=q4=Merciless Gladiator's Chain Spaulders", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 31960, "INV_Chest_Chain_11", "=q4=Merciless Gladiator's Chain Armor", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 31961, "INV_Gauntlets_11", "=q4=Merciless Gladiator's Chain Gauntlets", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 31963, "INV_Pants_Mail_15", "=q4=Merciless Gladiator's Chain Leggings", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#arena2s3#", "" },
        { 32048, "INV_Helmet_08", "=q4=Merciless Gladiator's Silk Cowl", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 32047, "INV_Shoulder_19", "=q4=Merciless Gladiator's Silk Amice", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 32050, "INV_Chest_Leather_01", "=q4=Merciless Gladiator's Silk Raiment", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 32049, "INV_Gauntlets_19", "=q4=Merciless Gladiator's Silk Handguards", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 32051, "INV_Pants_07", "=q4=Merciless Gladiator's Silk Trousers", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Paladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#arena2s4_1#", "" },
        { 31997, "INV_Helmet_22", "=q4=Merciless Gladiator's Lamellar Helm", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 31996, "INV_Shoulder_22", "=q4=Merciless Gladiator's Lamellar Shoulders", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 31992, "INV_Chest_Plate05", "=q4=Merciless Gladiator's Lamellar Chestpiece", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 31993, "INV_Gauntlets_29", "=q4=Merciless Gladiator's Lamellar Gauntlets", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 31995, "INV_Pants_Plate_17", "=q4=Merciless Gladiator's Lamellar Legguards", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arena2s4_2#", "" },
        { 32041, "INV_Helmet_22", "=q4=Merciless Gladiator's Scaled Helm", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 32043, "INV_Shoulder_22", "=q4=Merciless Gladiator's Scaled Shoulders", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 32039, "INV_Chest_Plate05", "=q4=Merciless Gladiator's Scaled Chestpiece", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 32040, "INV_Gauntlets_29", "=q4=Merciless Gladiator's Scaled Gauntlets", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 32042, "INV_Pants_Plate_17", "=q4=Merciless Gladiator's Scaled Legguards", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#arena2s4_3#", "" },
        { 32022, "INV_Helmet_22", "=q4=Merciless Gladiator's Ornamented Headcover", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 32024, "INV_Shoulder_22", "=q4=Merciless Gladiator's Ornamented Spaulders", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 32020, "INV_Chest_Plate05", "=q4=Merciless Gladiator's Ornamented Chestguard", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 32021, "INV_Gauntlets_29", "=q4=Merciless Gladiator's Ornamented Gloves", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 32023, "INV_Pants_Plate_17", "=q4=Merciless Gladiator's Ornamented Legplates", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arena2s5_1#", "" },
        { 32035, "INV_Helmet_30", "=q4=Merciless Gladiator's Satin Hood", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 32037, "INV_Shoulder_02", "=q4=Merciless Gladiator's Satin Mantle", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 32038, "INV_Chest_Cloth_43", "=q4=Merciless Gladiator's Satin Robe", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 32034, "INV_Gauntlets_15", "=q4=Merciless Gladiator's Satin Gloves", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 32036, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Satin Leggings", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Holy_PowerWordShield", "=q6=#arena2s5_2#", "" },
        { 32016, "INV_Helmet_30", "=q4=Merciless Gladiator's Mooncloth Hood", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 32018, "INV_Shoulder_02", "=q4=Merciless Gladiator's Mooncloth Mantle", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 32019, "INV_Chest_Cloth_43", "=q4=Merciless Gladiator's Mooncloth Robe", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 32015, "INV_Gauntlets_15", "=q4=Merciless Gladiator's Mooncloth Gloves", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 32017, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Mooncloth Leggings", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Rogue = {
        { 0, "Ability_BackStab", "=q6=#arena2s6#", "" },
        { 31999, "INV_Helmet_30", "=q4=Merciless Gladiator's Leather Helm", "=ds=#a2#, #s1#", "", "1875", "#arena#" },
        { 32001, "INV_Shoulder_12", "=q4=Merciless Gladiator's Leather Spaulders", "=ds=#a2#, #s3#", "", "1500", "#arena#" },
        { 32002, "INV_Chest_Leather_03", "=q4=Merciless Gladiator's Leather Tunic", "=ds=#a2#, #s5#", "", "1875", "#arena#" },
        { 31998, "INV_Gauntlets_28", "=q4=Merciless Gladiator's Leather Gloves", "=ds=#a2#, #s9#", "", "1125", "#arena#" },
        { 32000, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Leather Legguards", "=ds=#a2#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arena2s7_1#", "" },
        { 32006, "INV_Helmet_09", "=q4=Merciless Gladiator's Linked Helm", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 32008, "INV_Shoulder_29", "=q4=Merciless Gladiator's Linked Spaulders", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 32004, "INV_Chest_Chain_11", "=q4=Merciless Gladiator's Linked Armor", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 32005, "INV_Gauntlets_11", "=q4=Merciless Gladiator's Linked Gauntlets", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 32007, "INV_Pants_Mail_15", "=q4=Merciless Gladiator's Linked Leggings", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arena2s7_2#", "" },
        { 32011, "INV_Helmet_09", "=q4=Merciless Gladiator's Mail Helm", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 32013, "INV_Shoulder_29", "=q4=Merciless Gladiator's Mail Spaulders", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 32009, "INV_Chest_Chain_11", "=q4=Merciless Gladiator's Mail Armor", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 32010, "INV_Gauntlets_11", "=q4=Merciless Gladiator's Mail Gauntlets", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 32012, "INV_Pants_Mail_15", "=q4=Merciless Gladiator's Mail Leggings", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#arena2s7_3#", "" },
        { 32031, "INV_Helmet_09", "=q4=Merciless Gladiator's Ringmail Helm", "=ds=#a3#, #s1#", "", "1875", "#arena#" },
        { 32033, "INV_Shoulder_29", "=q4=Merciless Gladiator's Ringmail Spaulders", "=ds=#a3#, #s3#", "", "1500", "#arena#" },
        { 32029, "INV_Chest_Chain_11", "=q4=Merciless Gladiator's Ringmail Armor", "=ds=#a3#, #s5#", "", "1875", "#arena#" },
        { 32030, "INV_Gauntlets_11", "=q4=Merciless Gladiator's Ringmail Gauntlets", "=ds=#a3#, #s9#", "", "1125", "#arena#" },
        { 32032, "INV_Pants_Mail_15", "=q4=Merciless Gladiator's Ringmail Leggings", "=ds=#a3#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arena2s8_1#", "" },
        { 31974, "INV_Helmet_30", "=q4=Merciless Gladiator's Dreadweave Hood", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 31976, "INV_Shoulder_02", "=q4=Merciless Gladiator's Dreadweave Mantle", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 31977, "INV_Chest_Cloth_43", "=q4=Merciless Gladiator's Dreadweave Robe", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 31973, "INV_Gauntlets_15", "=q4=Merciless Gladiator's Dreadweave Gloves", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 31975, "INV_Pants_Cloth_05", "=q4=Merciless Gladiator's Dreadweave Leggings", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        { 0,"","","" },
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#arena2s8_2#", "" },
        { 31980, "INV_Helmet_08", "=q4=Merciless Gladiator's Felweave Cowl", "=ds=#a1#, #s1#", "", "1875", "#arena#" },
        { 31979, "INV_Shoulder_19", "=q4=Merciless Gladiator's Felweave Amice", "=ds=#a1#, #s3#", "", "1500", "#arena#" },
        { 31982, "INV_Chest_Leather_01", "=q4=Merciless Gladiator's Felweave Raiment", "=ds=#a1#, #s5#", "", "1875", "#arena#" },
        { 31981, "INV_Gauntlets_19", "=q4=Merciless Gladiator's Felweave Handguards", "=ds=#a1#, #s9#", "", "1125", "#arena#" },
        { 31983, "INV_Pants_07", "=q4=Merciless Gladiator's Felweave Trousers", "=ds=#a1#, #s11#", "", "1875", "#arena#" },
        };

    Arena2Warrior = {
        { 0, "INV_Shield_05", "=q6=#arena2s9#", "" },
        { 30488, "INV_Helmet_22", "=q4=Merciless Gladiator's Plate Helm", "=ds=#a4#, #s1#", "", "1875", "#arena#" },
        { 30490, "INV_Shoulder_22", "=q4=Merciless Gladiator's Plate Shoulders", "=ds=#a4#, #s3#", "", "1500", "#arena#" },
        { 30486, "INV_Chest_Plate05", "=q4=Merciless Gladiator's Plate Chestpiece", "=ds=#a4#, #s5#", "", "1875", "#arena#" },
        { 30487, "INV_Gauntlets_29", "=q4=Merciless Gladiator's Plate Gauntlets", "=ds=#a4#, #s9#", "", "1125", "#arena#" },
        { 30489, "INV_Pants_Plate_17", "=q4=Merciless Gladiator's Plate Legguards", "=ds=#a4#, #s11#", "", "1875", "#arena#" },
        };

-- Tier 6 Sets (T6)

    T6Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t6s1_1#","" },
        { 31039, "INV_Helmet_94", "=q4=Thunderheart Cover", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31048, "INV_Shoulder_58", "=q4=Thunderheart Pauldrons", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31042, "INV_Chest_Leather_15", "=q4=Thunderheart Chestguard", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31034, "INV_Gauntlets_58", "=q4=Thunderheart Gauntlets", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31044, "INV_Pants_Leather_26", "=q4=Thunderheart Leggings", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t6s1_2#","" },
        { 31037, "INV_Helmet_94", "=q4=Thunderheart Helmet", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31047, "INV_Shoulder_58", "=q4=Thunderheart Spaulders", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31041, "INV_Chest_Leather_15", "=q4=Thunderheart Tunic", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31032, "INV_Gauntlets_58", "=q4=Thunderheart Gloves", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31045, "INV_Pants_Leather_26", "=q4=Thunderheart Legguards", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t6s1_3#","" },
        { 31040, "INV_Helmet_94", "=q4=Thunderheart Headguard", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31049, "INV_Shoulder_58", "=q4=Thunderheart Shoulderpads", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31043, "INV_Chest_Leather_15", "=q4=Thunderheart Vest", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31035, "INV_Gauntlets_58", "=q4=Thunderheart Handguards", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31046, "INV_Pants_Leather_26", "=q4=Thunderheart Pants", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t6s2#","" },
        { 31003, "INV_Helmet_95", "=q4=Gronnstalker's Helmet", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31006, "INV_Shoulder_59", "=q4=Gronnstalker's Spaulders", "=ds="..AtlasLootBossNames["BlackTemple"][7] }, 
        { 31004, "INV_Chest_Mail_03", "=q4=Gronnstalker's Chestguard", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31001, "INV_Gauntlets_59", "=q4=Gronnstalker's Gloves", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31005, "INV_Pants_Mail_24", "=q4=Gronnstalker's Leggings", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t6s3#","" },
        { 31056, "Inv_Helmet_101", "=q4=Cowl of the Tempest", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31059, "Inv_Shoulder_64", "=q4=Mantle of the Tempest", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31057, "Inv_Chest_Cloth_67", "=q4=Robes of the Tempest", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31055, "Inv_Gauntlets_64", "=q4=Gloves of the Tempest", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31058, "Inv_Pants_Cloth_28", "=q4=Leggings of the Tempest", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t6s4_1#","" },
        { 30987, "INV_Helmet_96", "=q4=Lightbringer Faceguard", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30998, "INV_Shoulder_60", "=q4=Lightbringer Shoulderguards", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30991, "INV_Chest_Plate_22", "=q4=Lightbringer Chestguard", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30985, "INV_Gauntlets_60", "=q4=Lightbringer Handguards", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30995, "INV_Pants_Plate_26", "=q4=Lightbringer Legguards", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t6s4_2#","" },
        { 30989, "INV_Helmet_96", "=q4=Lightbringer War-Helm", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30997, "INV_Shoulder_60", "=q4=Lightbringer Shoulderbraces", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30990, "INV_Chest_Plate_22", "=q4=Lightbringer Breastplate", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30982, "INV_Gauntlets_60", "=q4=Lightbringer Gauntlets", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30993, "INV_Pants_Plate_26", "=q4=Lightbringer Greaves", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t6s4_3#","" },
        { 30988, "INV_Helmet_96", "=q4=Lightbringer Greathelm", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30996, "INV_Shoulder_60", "=q4=Lightbringer Pauldrons", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30992, "INV_Chest_Plate_22", "=q4=Lightbringer Chestpiece", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30983, "INV_Gauntlets_60", "=q4=Lightbringer Gloves", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30994, "INV_Pants_Plate_26", "=q4=Lightbringer Leggings", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t6s5_1#","" },
        { 31064, "INV_Helmet_99", "=q4=Hood of Absolution", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31070, "INV_Shoulder_63", "=q4=Shoulderpads of Absolution", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31065, "INV_Chest_Cloth_66", "=q4=Shroud of Absolution", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31061, "INV_Gauntlets_63", "=q4=Handguards of Absolution", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31067, "INV_Pants_Cloth_27", "=q4=Leggings of Absolution", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_Holy_PowerWordShield","=q6=#t6s5_2#","" },
        { 31063, "INV_Helmet_99", "=q4=Cowl of Absolution", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31069, "INV_Shoulder_63", "=q4=Mantle of Absolution", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31066, "INV_Chest_Cloth_66", "=q4=Vestments of Absolution", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31060, "INV_Gauntlets_63", "=q4=Gloves of Absolution", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31068, "INV_Pants_Cloth_27", "=q4=Breeches of Absolution", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Rogue = {
        { 0,"Ability_BackStab","=q6=#t6s6#","" },
        { 31027, "Inv_Helmet_102", "=q4=Slayer's Helm", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31030, "Inv_Shoulder_67", "=q4=Slayer's Shoulderpads", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31028, "Inv_Chest_Leather_16", "=q4=Slayer's Chestguard", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31026, "Inv_Gauntlets_65", "=q4=Slayer's Handguards", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31029, "Inv_Pants_Leather_27", "=q4=Slayer's Legguards", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t6s7_1#","" },
        { 31015, "INV_Helmet_97", "=q4=Skyshatter Cover", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31024, "INV_Shoulder_61", "=q4=Skyshatter Pauldrons", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31018, "INV_Chest_Mail_04", "=q4=Skyshatter Tunic", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31011, "INV_Gauntlets_61", "=q4=Skyshatter Grips", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31021, "INV_Pants_Mail_25", "=q4=Skyshatter Pants", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t6s7_2#","" },
        { 31012, "INV_Helmet_97", "=q4=Skyshatter Helmet", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31022, "INV_Shoulder_61", "=q4=Skyshatter Shoulderpads", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31016, "INV_Chest_Mail_04", "=q4=Skyshatter Chestguard", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31007, "INV_Gauntlets_61", "=q4=Skyshatter Gloves", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31019, "INV_Pants_Mail_25", "=q4=Skyshatter Leggings", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t6s7_3#","" },
        { 31014, "INV_Helmet_97", "=q4=Skyshatter Headguard", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31023, "INV_Shoulder_61", "=q4=Skyshatter Mantle", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31017, "INV_Chest_Mail_04", "=q4=Skyshatter Breastplate", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31008, "INV_Gauntlets_61", "=q4=Skyshatter Gauntlets", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31020, "INV_Pants_Mail_25", "=q4=Skyshatter Legguards", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t6s8#","" },
        { 31051, "INV_Helmet_103", "=q4=Hood of the Malefic", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 31054, "INV_Shoulder_68", "=q4=Mantle of the Malefic", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 31052, "INV_Chest_Cloth_68", "=q4=Robe of the Malefic", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 31050, "INV_Gauntlets_66", "=q4=Gloves of the Malefic", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 31053, "INV_Pants_Cloth_29", "=q4=Leggings of the Malefic", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

    T6Warrior = {
        { 0,"INV_Shield_05","=q6=#t6s9_1#","" },
        { 30974, "INV_Helmet_98", "=q4=Onslaught Greathelm", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30980, "INV_Shoulder_62", "=q4=Onslaught Shoulderguards", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30976, "INV_Chest_Plate_23", "=q4=Onslaught Chestguard", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30970, "INV_Gauntlets_62", "=q4=Onslaught Handguards", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30978, "INV_Pants_Plate_27", "=q4=Onslaught Legguards", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        { 0,"","","" },
        { 0,"INV_Shield_05","=q6=#t6s9_2#","" },
        { 30972, "INV_Helmet_98", "=q4=Onslaught Battle-Helm", "=ds="..AtlasLootBossNames["CoTMountHyjal"][5] },
        { 30979, "INV_Shoulder_62", "=q4=Onslaught Shoulderblades", "=ds="..AtlasLootBossNames["BlackTemple"][7] },
        { 30975, "INV_Chest_Plate_23", "=q4=Onslaught Breastplate", "=ds="..AtlasLootBossNames["BlackTemple"][9] },
        { 30969, "INV_Gauntlets_62", "=q4=Onslaught Gauntlets", "=ds="..AtlasLootBossNames["CoTMountHyjal"][4] },
        { 30977, "INV_Pants_Plate_27", "=q4=Onslaught Greaves", "=ds="..AtlasLootBossNames["BlackTemple"][8] },
        };

-- Tier 5 Sets (T5)

    T5Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t5s1_1#","" },
        { 30228, "INV_Helmet_15", "=q4=Nordrassil Headdress", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30230, "INV_Shoulder_14", "=q4=Nordrassil Feral-Mantle", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30222, "INV_Chest_Chain_15", "=q4=Nordrassil Chestplate", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30223, "INV_Gauntlets_25", "=q4=Nordrassil Handgrips", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30229, "INV_Pants_Mail_15", "=q4=Nordrassil Feral-Kilt", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t5s1_2#","" },
        { 30219, "INV_Helmet_15", "=q4=Nordrassil Headguard", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30221, "INV_Shoulder_14", "=q4=Nordrassil Life-Mantle", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30216, "INV_Chest_Chain_15", "=q4=Nordrassil Chestguard", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30217, "INV_Gauntlets_25", "=q4=Nordrassil Gloves", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30220, "INV_Pants_Mail_15", "=q4=Nordrassil Life-Kilt", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t5s1_3#","" },
        { 30233, "INV_Helmet_15", "=q4=Nordrassil Headpiece", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30235, "INV_Shoulder_14", "=q4=Nordrassil Wrath-Mantle", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30231, "INV_Chest_Chain_15", "=q4=Nordrassil Chestpiece", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30232, "INV_Gauntlets_25", "=q4=Nordrassil Gauntlets", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30234, "INV_Pants_Mail_15", "=q4=Nordrassil Wrath-Kilt", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t5s2#","" },
        { 30141, "INV_Helmet_15", "=q4=Rift Stalker Helm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30143, "INV_Shoulder_14", "=q4=Rift Stalker Mantle", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30139, "INV_Chest_Chain_15", "=q4=Rift Stalker Hauberk", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30140, "INV_Gauntlets_25", "=q4=Rift Stalker Gauntlets", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30142, "INV_Pants_Mail_15", "=q4=Rift Stalker Leggings", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };
        
    T5Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t5s3#","" },
        { 30206, "INV_Crown_01", "=q4=Cowl of Tirisfal", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30210, "INV_Shoulder_25", "=q4=Mantle of Tirisfal", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30196, "INV_Chest_Cloth_43", "=q4=Robes of Tirisfal", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30205, "INV_Gauntlets_17", "=q4=Gloves of Tirisfal", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30207, "INV_Pants_Cloth_05", "=q4=Leggings of Tirisfal", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };
        
    T5Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t5s4_1#","" },
        { 30125, "INV_Helmet_15", "=q4=Crystalforge Faceguard", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30127, "INV_Shoulder_14", "=q4=Crystalforge Shoulderguards", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30123, "INV_Chest_Chain_15", "=q4=Crystalforge Chestguard", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30124, "INV_Gauntlets_25", "=q4=Crystalforge Handguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30126, "INV_Pants_Mail_15", "=q4=Crystalforge Legguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t5s4_2#","" },
        { 30131, "INV_Helmet_15", "=q4=Crystalforge War-Helm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30133, "INV_Shoulder_14", "=q4=Crystalforge Shoulderbraces", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30129, "INV_Chest_Chain_15", "=q4=Crystalforge Breastplate", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30130, "INV_Gauntlets_25", "=q4=Crystalforge Gauntlets", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30132, "INV_Pants_Mail_15", "=q4=Crystalforge Greaves", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t5s4_3#","" },
        { 30136, "INV_Helmet_15", "=q4=Crystalforge Greathelm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30138, "INV_Shoulder_14", "=q4=Crystalforge Pauldrons", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30134, "INV_Chest_Chain_15", "=q4=Crystalforge Chestpiece", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30135, "INV_Gauntlets_25", "=q4=Crystalforge Gloves", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30137, "INV_Pants_Mail_15", "=q4=Crystalforge Leggings", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t5s5_1#","" },
        { 30152, "INV_Crown_01", "=q4=Cowl of the Avatar", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30154, "INV_Shoulder_25", "=q4=Mantle of the Avatar", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30150, "INV_Chest_Cloth_43", "=q4=Vestments of the Avatar", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30151, "INV_Gauntlets_17", "=q4=Gloves of the Avatar", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30153, "INV_Pants_Cloth_05", "=q4=Breeches of the Avatar", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_Holy_PowerWordShield","=q6=#t5s5_2#","" },
        { 30161, "INV_Crown_01", "=q4=Hood of the Avatar", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30163, "INV_Shoulder_25", "=q4=Wings of the Avatar", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30159, "INV_Chest_Cloth_43", "=q4=Shroud of the Avatar", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30160, "INV_Gauntlets_17", "=q4=Handguards of the Avatar", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30162, "INV_Pants_Cloth_05", "=q4=Leggings of the Avatar", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Rogue = {
        { 0,"Ability_BackStab","=q6=#t5s6#","" },
        { 30146, "INV_Helmet_58", "=q4=Deathmantle Helm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30149, "INV_Shoulder_29", "=q4=Deathmantle Shoulderpads", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30144, "INV_Chest_Plate02", "=q4=Deathmantle Chestguard", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30145, "INV_Gauntlets_28", "=q4=Deathmantle Handguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30148, "INV_Pants_Plate_05", "=q4=Deathmantle Legguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t5s7_1#","" },
        { 30190, "INV_Helmet_15", "=q4=Cataclysm Helm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30194, "INV_Shoulder_14", "=q4=Cataclysm Shoulderplates", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30185, "INV_Chest_Plate08", "=q4=Cataclysm Chestplate", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30189, "INV_Gauntlets_25", "=q4=Cataclysm Gauntlets", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30192, "INV_Pants_Mail_15", "=q4=Cataclysm Legplates", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t5s7_2#","" },
        { 30166, "INV_Helmet_15", "=q4=Cataclysm Headguard", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30168, "INV_Shoulder_14", "=q4=Cataclysm Shoulderguards", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30164, "INV_Chest_Plate08", "=q4=Cataclysm Chestguard", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30165, "INV_Gauntlets_25", "=q4=Cataclysm Gloves", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30167, "INV_Pants_Mail_15", "=q4=Cataclysm Legguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t5s7_3#","" },
        { 30171, "INV_Helmet_15", "=q4=Cataclysm Headpiece", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30173, "INV_Shoulder_14", "=q4=Cataclysm Shoulderpads", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30169, "INV_Chest_Plate08", "=q4=Cataclysm Chestpiece", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30170, "INV_Gauntlets_25", "=q4=Cataclysm Handgrips", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30172, "INV_Pants_Mail_15", "=q4=Cataclysm Legguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

    T5Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t5s8#","" },
        { 30212, "INV_Crown_01", "=q4=Hood of the Corruptor", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30215, "INV_Shoulder_25", "=q4=Mantle of the Corruptor", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30214, "INV_Chest_Cloth_43", "=q4=Robe of the Corruptor", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30211, "INV_Gauntlets_17", "=q4=Gloves of the Corruptor", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30213, "INV_Pants_Cloth_05", "=q4=Leggings of the Corruptor", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };
                
    T5Warrior = {
        { 0,"INV_Shield_05","=q6=#t5s9_1#","" },
        { 30115, "INV_Helmet_58", "=q4=Destroyer Greathelm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30117, "INV_Shoulder_29", "=q4=Destroyer Shoulderguards", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30113, "INV_Chest_Plate02", "=q4=Destroyer Chestguard", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30114, "INV_Gauntlets_28", "=q4=Destroyer Handguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30116, "INV_Pants_Plate_05", "=q4=Destroyer Legguards", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        { 0,"","","" },
        { 0,"INV_Shield_05","=q6=#t5s9_2#","" },
        { 30120, "INV_Helmet_58", "=q4=Destroyer Battle-Helm", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][6] },
        { 30122, "INV_Shoulder_29", "=q4=Destroyer Shoulderblades", "=ds="..AtlasLootBossNames["TKTheEye"][1] },
        { 30118, "INV_Chest_Plate02", "=q4=Destroyer Breastplate", "=ds="..AtlasLootBossNames["TKTheEye"][4] },
        { 30119, "INV_Gauntlets_28", "=q4=Destroyer Gauntlets", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][2] },
        { 30121, "INV_Pants_Plate_05", "=q4=Destroyer Greaves", "=ds="..AtlasLootBossNames["CFRSerpentshrineCavern"][3] },
        };

-- Tier 4 Sets (T4)
        
    T4Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t4s1_1#","" },
        { 29098, "INV_Helmet_15", "=q4=Stag-Helm of Malorne", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29100, "INV_Shoulder_14", "=q4=Mantle of Malorne", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29096, "INV_Chest_Chain_15", "=q4=Breastplate of Malorne", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29097, "INV_Gauntlets_25", "=q4=Gauntlets of Malorne", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29099, "INV_Pants_Mail_15", "=q4=Greaves of Malorne", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t4s1_2#","" },
        { 29086, "INV_Helmet_15", "=q4=Crown of Malorne", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29089, "INV_Shoulder_14", "=q4=Shoulderguards of Malorne", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29087, "INV_Chest_Chain_15", "=q4=Chestguard of Malorne", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29090, "INV_Gauntlets_25", "=q4=Handguards of Malorne", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29088, "INV_Pants_Mail_15", "=q4=Legguards of Malorne", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Nature_Regeneration","=q6=#t4s1_3#","" },
        { 29093, "INV_Helmet_15", "=q4=Antlers of Malorne", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29095, "INV_Shoulder_14", "=q4=Pauldrons of Malorne", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29091, "INV_Chest_Chain_15", "=q4=Chestpiece of Malorne", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29092, "INV_Gauntlets_25", "=q4=Gloves of Malorne", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29094, "INV_Pants_Mail_15", "=q4=Britches of Malorne", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
            
    T4Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t4s2#","" },
        { 29081, "INV_Helmet_15", "=q4=Demon Stalker Greathelm", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29084, "INV_Shoulder_14", "=q4=Demon Stalker Shoulderguards", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29082, "INV_Chest_Chain_15", "=q4=Demon Stalker Harness", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29085, "INV_Gauntlets_25", "=q4=Demon Stalker Gauntlets", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29083, "INV_Pants_Mail_15", "=q4=Demon Stalker Greaves", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
    
    T4Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t4s3#","" },
        { 29076, "INV_Crown_01", "=q4=Collar of the Aldor", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29079, "INV_Shoulder_25", "=q4=Pauldrons of the Aldor", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29077, "INV_Chest_Cloth_43", "=q4=Vestments of the Aldor", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29080, "INV_Gauntlets_17", "=q4=Gloves of the Aldor", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29078, "INV_Pants_Cloth_05", "=q4=Legwraps of the Aldor", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
        
    T4Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t4s4_1#","" },
        { 29068, "INV_Helmet_15", "=q4=Justicar Faceguard", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29070, "INV_Shoulder_14", "=q4=Justicar Shoulderguards", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29066, "INV_Chest_Chain_15", "=q4=Justicar Chestguard", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29067, "INV_Gauntlets_25", "=q4=Justicar Handguards", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29069, "INV_Pants_Mail_15", "=q4=Justicar Legguards", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t4s4_2#","" },
        { 29073, "INV_Helmet_15", "=q4=Justicar Crown", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29075, "INV_Shoulder_14", "=q4=Justicar Shoulderplates", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29071, "INV_Chest_Chain_15", "=q4=Justicar Breastplate", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29072, "INV_Gauntlets_25", "=q4=Justicar Gauntlets", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29074, "INV_Pants_Mail_15", "=q4=Justicar Greaves", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_Holy_SealOfMight","=q6=#t4s4_3#","" },
        { 29061, "INV_Helmet_15", "=q4=Justicar Diadem", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29064, "INV_Shoulder_14", "=q4=Justicar Pauldrons", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29062, "INV_Chest_Chain_15", "=q4=Justicar Chestpiece", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29065, "INV_Gauntlets_25", "=q4=Justicar Gloves", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29063, "INV_Pants_Mail_15", "=q4=Justicar Leggings", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t4s5_1#","" },
        { 29049, "INV_Crown_01", "=q4=Light-Collar of the Incarnate", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29054, "INV_Shoulder_25", "=q4=Light-Mantle of the Incarnate", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29050, "INV_Chest_Cloth_43", "=q4=Robes of the Incarnate", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29055, "INV_Gauntlets_17", "=q4=Handwraps of the Incarnate", AtlasLootBossNames["Karazhan"][1] },
        { 29053, "INV_Pants_Cloth_05", "=q4=Trousers of the Incarnate", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_Holy_PowerWordShield","=q6=#t4s5_2#","" },
        { 29058, "INV_Crown_01", "=q4=Soul-Collar of the Incarnate", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29060, "INV_Shoulder_25", "=q4=Soul-Mantle of the Incarnate", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29056, "INV_Chest_Cloth_43", "=q4=Shroud of the Incarnate", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29057, "INV_Gauntlets_17", "=q4=Gloves of the Incarnate", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29059, "INV_Pants_Cloth_05", "=q4=Leggings of the Incarnate", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Rogue = {
        { 0,"Ability_BackStab","=q6=#t4s6#","" },
        { 29044, "INV_Helmet_58", "=q4=Netherblade Facemask", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29047, "INV_Shoulder_29", "=q4=Netherblade Shoulderpads", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29045, "INV_Chest_Plate02", "=q4=Netherblade Chestpiece", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29048, "INV_Gauntlets_28", "=q4=Netherblade Gloves", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29046, "INV_Pants_Plate_05", "=q4=Netherblade Breeches", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t4s7_1#","" },
        { 29040, "INV_Helmet_15", "=q4=Cyclone Helm", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29043, "INV_Shoulder_14", "=q4=Cyclone Shoulderplates", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29038, "INV_Chest_Chain_15", "=q4=Cyclone Breastplate", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29039, "INV_Gauntlets_25", "=q4=Cyclone Gauntlets", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29042, "INV_Pants_Mail_15", "=q4=Cyclone War-Kilt", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t4s7_2#","" },
        { 29028, "INV_Helmet_15", "=q4=Cyclone Headdress", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29031, "INV_Shoulder_14", "=q4=Cyclone Shoulderpads", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29029, "INV_Chest_Chain_15", "=q4=Cyclone Hauberk", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29032, "INV_Gauntlets_25", "=q4=Cyclone Gloves", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29030, "INV_Pants_Mail_15", "=q4=Cyclone Kilt", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"Spell_FireResistanceTotem_01","=q6=#t4s7_3#","" },
        { 29035, "INV_Helmet_15", "=q4=Cyclone Faceguard", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29037, "INV_Shoulder_14", "=q4=Cyclone Shoulderguards", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29033, "INV_Chest_Chain_15", "=q4=Cyclone Chestguard", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29034, "INV_Gauntlets_25", "=q4=Cyclone Handguards", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29036, "INV_Pants_Mail_15", "=q4=Cyclone Legguards", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

    T4Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t4s8#","" },
        { 28963, "INV_Crown_01", "=q4=Voidheart Crown", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 28967, "INV_Shoulder_25", "=q4=Voidheart Mantle", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 28964, "INV_Chest_Cloth_43", "=q4=Voidheart Robe", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 28968, "INV_Gauntlets_17", "=q4=Voidheart Gloves", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 28966, "INV_Pants_Cloth_05", "=q4=Voidheart Leggings", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };
     
    T4Warrior = {
        { 0,"INV_Shield_05","=q6=#t4s9_1#","" },
        { 29011, "INV_Helmet_58", "=q4=Warbringer Greathelm", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29016, "INV_Shoulder_29", "=q4=Warbringer Shoulderguards", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29012, "INV_Chest_Plate02", "=q4=Warbringer Chestguard", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29017, "INV_Gauntlets_28", "=q4=Warbringer Handguards", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29015, "INV_Pants_Plate_05", "=q4=Warbringer Legguards", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        { 0,"","","" },
        { 0,"INV_Shield_05","=q6=#t4s9_2#","" },
        { 29021, "INV_Helmet_58", "=q4=Warbringer Battle-Helm", "=ds="..AtlasLootBossNames["Karazhan"][2] },
        { 29023, "INV_Shoulder_29", "=q4=Warbringer Shoulderplates", "=ds="..AtlasLootBossNames["GruulsLair"][1] },
        { 29019, "INV_Chest_Plate02", "=q4=Warbringer Breastplate", "=ds="..AtlasLootBossNames["MagtheridonsLair"][1] },
        { 29020, "INV_Gauntlets_28", "=q4=Warbringer Gauntlets", "=ds="..AtlasLootBossNames["Karazhan"][1] },
        { 29022, "INV_Pants_Plate_05", "=q4=Warbringer Greaves", "=ds="..AtlasLootBossNames["GruulsLair"][2] },
        };

-- Tier 3 Sets (T3)
        
    T3Druid = {
        { 0,"Spell_Nature_Regeneration","=q6=#t3s1#","" },
        { 22490, "INV_Helmet_15", "=q4=Dreamwalker Headpiece", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22491, "INV_Shoulder_14", "=q4=Dreamwalker Spaulders", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22488, "INV_Chest_Chain_15", "=q4=Dreamwalker Tunic", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22495, "INV_Bracer_02", "=q4=Dreamwalker Wristguards", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22493, "INV_Gauntlets_25", "=q4=Dreamwalker Handguards", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22494, "INV_Belt_22", "=q4=Dreamwalker Girdle", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22489, "INV_Pants_Mail_15", "=q4=Dreamwalker Legguards", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22492, "INV_Boots_Chain_05", "=q4=Dreamwalker Boots", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23064, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of the Dreamwalker", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Hunter = {
        { 0,"Ability_Hunter_RunningShot","=q6=#t3s2#","" },
        { 22438, "INV_Helmet_15", "=q4=Cryptstalker Headpiece", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22439, "INV_Shoulder_14", "=q4=Cryptstalker Spaulders", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22436, "INV_Chest_Chain_15", "=q4=Cryptstalker Tunic", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22443, "INV_Bracer_02", "=q4=Cryptstalker Wristguards", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22441, "INV_Gauntlets_25", "=q4=Cryptstalker Handguards", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22442, "INV_Belt_22", "=q4=Cryptstalker Girdle", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22437, "INV_Pants_Mail_15", "=q4=Cryptstalker Legguards", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22440, "INV_Boots_Chain_05", "=q4=Cryptstalker Boots", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23067, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of the Cryptstalker", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Mage = {
        { 0,"Spell_Frost_IceStorm","=q6=#t3s3#", ""},
        { 22498, "INV_Crown_01", "=q4=Frostfire Circlet", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22499, "INV_Shoulder_25", "=q4=Frostfire Shoulderpads", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22496, "INV_Chest_Cloth_43", "=q4=Frostfire Robe", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22503, "INV_Bracer_13", "=q4=Frostfire Bindings", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22501, "INV_Gauntlets_17", "=q4=Frostfire Gloves", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22502, "INV_Belt_03", "=q4=Frostfire Belt", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22497, "INV_Pants_Cloth_05", "=q4=Frostfire Leggings", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22500, "INV_Boots_Fabric_01", "=q4=Frostfire Sandals", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9]  },
        { 23062, "INV_Jewelry_Ring_51Naxxramas", "=q4=Frostfire Ring", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Paladin = {
        { 0,"Spell_Holy_SealOfMight","=q6=#t3s4#","" },
        { 22428, "INV_Helmet_15", "=q4=Redemption Headpiece", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22429, "INV_Shoulder_14", "=q4=Redemption Spaulders", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22425, "INV_Chest_Chain_15", "=q4=Redemption Tunic", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22424, "INV_Bracer_02", "=q4=Redemption Wristguards", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22426, "INV_Gauntlets_25", "=q4=Redemption Handguards", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22431, "INV_Belt_22", "=q4=Redemption Girdle", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22427, "INV_Pants_Mail_15", "=q4=Redemption Legguards", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22430, "INV_Boots_Chain_05", "=q4=Redemption Boots", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23066, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of Redemption", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Priest = {
        { 0,"Spell_Holy_PowerWordShield","=q6=#t3s5#","" },
        { 22514, "INV_Crown_01", "=q4=Circlet of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22515, "INV_Shoulder_25", "=q4=Shoulderpads of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22512, "INV_Chest_Cloth_43", "=q4=Robe of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22519, "INV_Bracer_13", "=q4=Bindings of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22517, "INV_Gauntlets_17", "=q4=Gloves of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22518, "INV_Belt_08", "=q4=Belt of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22513, "INV_Pants_Cloth_05", "=q4=Leggings of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22516, "INV_Boots_Fabric_01", "=q4=Sandals of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23061, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of Faith", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Rogue = {
        { 0,"Ability_BackStab","=q6=#t3s6#","" },
        { 22478, "INV_Helmet_58", "=q4=Bonescythe Helmet", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22479, "INV_Shoulder_29", "=q4=Bonescythe Pauldrons", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22476, "INV_Chest_Plate02", "=q4=Bonescythe Breastplate", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22483, "INV_Bracer_15", "=q4=Bonescythe Bracers", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22481, "INV_Gauntlets_28", "=q4=Bonescythe Gauntlets", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22482, "INV_Belt_27", "=q4=Bonescythe Waistguard", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22477, "INV_Pants_Plate_05", "=q4=Bonescythe Legplates", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22480, "INV_Boots_Plate_06", "=q4=Bonescythe Sabatons", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23060, "INV_Jewelry_Ring_51Naxxramas", "=q4=Bonescythe Ring", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Shaman = {
        { 0,"Spell_FireResistanceTotem_01","=q6=#t3s7#","" },
        { 22466, "INV_Helmet_15", "=q4=Earthshatter Headpiece", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22467, "INV_Shoulder_14", "=q4=Earthshatter Spaulders", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22464, "INV_Chest_Chain_15", "=q4=Earthshatter Tunic", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22471, "INV_Bracer_02", "=q4=Earthshatter Wristguards", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22469, "INV_Gauntlets_25", "=q4=Earthshatter Handguards", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22470, "INV_Belt_22", "=q4=Earthshatter Girdle", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22465, "INV_Pants_Mail_15", "=q4=Earthshatter Legguards", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22468, "INV_Boots_Chain_05", "=q4=Earthshatter Boots", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23065, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of the Earthshatterer", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Warlock = {
        { 0,"Spell_Shadow_CurseOfTounges","=q6=#t3s8#","" },
        { 22506, "INV_Crown_01", "=q4=Plagueheart Circlet", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22507, "INV_Shoulder_25", "=q4=Plagueheart Shoulderpads", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2]},
        { 22504, "INV_Chest_Cloth_43", "=q4=Plagueheart Robe", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22511, "INV_Bracer_13", "=q4=Plagueheart Bindings", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22509, "INV_Gauntlets_17", "=q4=Plagueheart Gloves", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22510, "INV_Belt_03", "=q4=Plagueheart Belt", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22505, "INV_Pants_Cloth_05", "=q4=Plagueheart Leggings", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22508, "INV_Boots_Fabric_01", "=q4=Plagueheart Sandals", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23063, "INV_Jewelry_Ring_51Naxxramas", "=q4=Plagueheart Ring", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

    T3Warrior = {
        { 0, "INV_Shield_05", "=q6=#t3s9#", "" },
        { 22418, "INV_Helmet_58", "=q4=Dreadnaught Helmet", "=ds="..AtlasLootBossNames["Naxxramas"][4] },
        { 22419, "INV_Shoulder_29", "=q4=Dreadnaught Pauldrons", "=ds="..AtlasLootBossNames["Naxxramas"][1]..", "..AtlasLootBossNames["Naxxramas"][2] },
        { 22416, "INV_Chest_Plate02", "=q4=Dreadnaught Breastplate", "=ds="..AtlasLootBossNames["Naxxramas"][10] },
        { 22423, "INV_Bracer_15", "=q4=Dreadnaught Bracers", "=ds="..AtlasLootBossNames["Naxxramas"][5]..", "..AtlasLootBossNames["Naxxramas"][6] },
        { 22421, "INV_Gauntlets_28", "=q4=Dreadnaught Gauntlets", "=ds="..AtlasLootBossNames["Naxxramas"][7] },
        { 22422, "INV_Belt_27", "=q4=Dreadnaught Waistguard", "=ds="..AtlasLootBossNames["Naxxramas"][11]..", "..AtlasLootBossNames["Naxxramas"][12] },
        { 22417, "INV_Pants_Plate_05", "=q4=Dreadnaught Legplates", "=ds="..AtlasLootBossNames["Naxxramas"][13] },
        { 22420, "INV_Boots_Plate_06", "=q4=Dreadnaught Sabatons", "=ds="..AtlasLootBossNames["Naxxramas"][3]..", "..AtlasLootBossNames["Naxxramas"][8]..", "..AtlasLootBossNames["Naxxramas"][9] },
        { 23059, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of the Dreadnaught", "=ds="..AtlasLootBossNames["Naxxramas"][15] },
        };

-- Tier 2 Sets (T2)
        
    T2Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#t2s1#", "" },        
        { 16900, "INV_Helmet_09", "=q4=Stormrage Cover", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.08%" },
	{ 16902, "INV_Shoulder_07", "=q4=Stormrage Pauldrons", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "14.63%" },
	{ 16897, "INV_Chest_Chain_16", "=q4=Stormrage Chestguard", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "11.89%" },
   	{ 16904, "INV_Bracer_03", "=q4=Stormrage Bracers", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "17.38%" },
        { 16899, "INV_Gauntlets_25", "=q4=Stormrage Handguards", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "5.34%" },
	{ 16903, "INV_Belt_06", "=q4=Stormrage Belt", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "16.90%" },
        { 16901, "INV_Pants_06", "=q4=Stormrage Legguards", "=ds="..AtlasLootBossNames["MoltenCore"][10], "15.49%" },
	{ 16898, "INV_Boots_08", "=q4=Stormrage Boots", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "13.79%" },
	};

    T2Hunter = {
	{ 0, "Ability_Hunter_RunningShot", "=q6=#t2s2#", "" },
        { 16939, "INV_Helmet_05", "=q4=Dragonstalker's Helm", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.91%" },
	{ 16937, "INV_Shoulder_10", "=q4=Dragonstalker's Spaulders", "=ds="..AtlasLootBossNames["BlackwingLair"][7],   "16.20%" },
	{ 16942, "INV_Chest_Chain_03", "=q4=Dragonstalker's Breastplate", "=ds="..AtlasLootBossNames["BlackwingLair"][8],   "13.30%" },
        { 16935, "INV_Bracer_17", "=q4=Dragonstalker's Bracers", "=ds="..AtlasLootBossNames["BlackwingLair"][1],       "19.13%" },
        { 16940, "INV_Gauntlets_10", "=q4=Dragonstalker's Gauntlets", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "6.13%" },
	{ 16936, "INV_Belt_28", "=q4=Dragonstalker's Belt", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "20.17%" },
        { 16938, "INV_Pants_03", "=q4=Dragonstalker's Legguards", "=ds="..AtlasLootBossNames["MoltenCore"][10], "16.02%" },
	{ 16941, "INV_Boots_Plate_07", "=q4=Dragonstalker's Greaves", "=ds="..AtlasLootBossNames["BlackwingLair"][3],     "17.78%" },
	};

    T2Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#t2s3#", "" },
        { 16914, "INV_Helmet_70", "=q4=Netherwind Crown", "=ds="..AtlasLootBossNames["OnyxiasLair"][1] , "14.09%" },
        { 16917, "INV_Shoulder_32", "=q4=Netherwind Mantle", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "18.09%" },
        { 16916, "INV_Chest_Cloth_03", "=q4=Netherwind Robes", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "14.03%" },
        { 16918, "INV_Bracer_09", "=q4=Netherwind Bindings", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.41%" },
        { 16913, "INV_Gauntlets_14", "=q4=Netherwind Gloves", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "7.37%" },
        { 16818, "INV_Belt_22", "=q4=Netherwind Belt", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "19.94%" },
        { 16915, "INV_Pants_08", "=q4=Netherwind Pants", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.37%" },
        { 16912, "INV_Boots_07", "=q4=Netherwind Boots", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "17.17%" },
        };

    T2Paladin = {
	{ 0, "Spell_Holy_SealOfMight", "=q6=#t2s4#", "" },
        { 16955, "INV_Helmet_74", "=q4=Judgement Crown", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "8.64%" },
	{ 16953, "INV_Shoulder_37", "=q4=Judgement Spaulders", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "10.97%" },
	{ 16958, "INV_Chest_Plate03", "=q4=Judgement Breastplate", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "9.24%" },
	{ 16951, "INV_Bracer_18", "=q4=Judgement Bindings", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "13.61%" },
        { 16956, "INV_Gauntlets_29", "=q4=Judgement Gauntlets", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "3.58%" },
	{ 16952, "INV_Belt_27", "=q4=Judgement Belt", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "12.23%" },
        { 16954, "INV_Pants_04", "=q4=Judgement Legplates", "=ds="..AtlasLootBossNames["MoltenCore"][10], "10.81%" },
	{ 16957, "INV_Boots_Plate_09", "=q4=Judgement Sabatons", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "11.28%" },
        };

    T2Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t2s5#", "" },
        { 16921, "INV_Helmet_24", "=q4=Halo of Transcendence",  "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.39%" },
        { 16924, "INV_Shoulder_02", "=q4=Pauldrons of Transcendence", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "17.83%" },
        { 16923, "INV_Chest_Cloth_03", "=q4=Robes of Transcendence", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "14.83%" },
        { 16926, "INV_Bracer_09", "=q4=Bindings of Transcendence", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.37%" },
        { 16920, "INV_Gauntlets_14", "=q4=Handguards of Transcendence", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "6.01%" },
        { 16925, "INV_Belt_22", "=q4=Belt of Transcendence", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "18.76%" },
        { 16922, "INV_Pants_08", "=q4=Leggings of Transcendence", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.30%" },
        { 16919, "INV_Boots_07", "=q4=Boots of Transcendence", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "14.61%" },
        };

    T2Rogue = {
        { 0, "Ability_BackStab", "=q6=#t2s6#", "" },
        { 16908, "INV_Helmet_41", "=q4=Bloodfang Hood", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.21%" },
        { 16832, "INV_Shoulder_23", "=q4=Bloodfang Spaulders", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "17.03%" },
        { 16905, "INV_Chest_Cloth_07", "=q4=Bloodfang Chestpiece", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "14.21%" },
        { 16911, "INV_Bracer_02", "=q4=Bloodfang Bracers", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.69%" },
        { 16907, "INV_Gauntlets_21", "=q4=Bloodfang Gloves", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "6.84%" },
        { 16910, "INV_Belt_23", "=q4=Bloodfang Belt", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "19.69%" },
        { 16909, "INV_Pants_06", "=q4=Bloodfang Pants", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.18%" },
        { 16906, "INV_Boots_08", "=q4=Bloodfang Boots", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "15.66%" },
        };

    T2Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t2s7#", "" },
        { 16947, "INV_Helmet_69", "=q4=Helmet of Ten Storms", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "4.86%" },
        { 16945, "INV_Shoulder_33", "=q4=Epaulets of Ten Storms", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "6.73%" },
        { 16950, "INV_Chest_Chain_11", "=q4=Breastplate of Ten Storms", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "5.65%" },
        { 16943, "INV_Bracer_16", "=q4=Bracers of Ten Storms", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "7.54%" },
        { 16948, "INV_Gauntlets_11", "=q4=Gauntlets of Ten Storms", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "2.13%" },
        { 16944, "INV_Belt_14", "=q4=Belt of Ten Storms", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "6.93%" },
        { 16946, "INV_Pants_03", "=q4=Legplates of Ten Storms", "=ds="..AtlasLootBossNames["MoltenCore"][10], "5.97%" },
        { 16949, "INV_Boots_Plate_06", "=q4=Greaves of Ten Storms", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "5.57%" },
        };

    T2Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t2s8#", "" },
        { 16929, "INV_Helmet_08", "=q4=Nemesis Skullcap","=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.54%" },
        { 16932, "INV_Shoulder_19", "=q4=Nemesis Spaulders", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "16.26%" },
        { 16931, "INV_Chest_Leather_01", "=q4=Nemesis Robes", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "12.46%" },
        { 16934, "INV_Bracer_07", "=q4=Nemesis Bracers", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "18.11%" },
        { 16928, "INV_Gauntlets_19", "=q4=Nemesis Gloves", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "5.28%" },
        { 16933, "INV_Belt_13", "=q4=Nemesis Belt", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "18.42%" },
        { 16930, "INV_Pants_07", "=q4=Nemesis Leggings", "=ds="..AtlasLootBossNames["MoltenCore"][10], "16.87%" },
        { 16927, "INV_Boots_05", "=q4=Nemesis Boots", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "15.32%" },
        };

    T2Warrior = {
        { 0, "INV_Shield_05", "=q6=#t2s9#", "" },
        { 16963, "INV_Helmet_71", "=q4=Helm of Wrath", "=ds="..AtlasLootBossNames["OnyxiasLair"][1], "13.65%" },
        { 16961, "INV_Shoulder_34", "=q4=Pauldrons of Wrath", "=ds="..AtlasLootBossNames["BlackwingLair"][7], "16.83%" },
        { 16966, "INV_Chest_Plate16", "=q4=Breastplate of Wrath", "=ds="..AtlasLootBossNames["BlackwingLair"][8], "15.06%" },
        { 16959, "INV_Bracer_19", "=q4=Bracelets of Wrath", "=ds="..AtlasLootBossNames["BlackwingLair"][1], "20.29%" },
        { 16964, "INV_Gauntlets_10", "=q4=Gauntlets of Wrath", "=ds="..AtlasLootBossNames["BlackwingLair"][4]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][5]..", ".."=ds="..AtlasLootBossNames["BlackwingLair"][6], "5.93%" },
        { 16960, "INV_Belt_09", "=q4=Waistband of Wrath", "=ds="..AtlasLootBossNames["BlackwingLair"][2], "20.03%" },
        { 16962, "INV_Pants_04", "=q4=Legplates of Wrath", "=ds="..AtlasLootBossNames["MoltenCore"][10], "17.23%" },
        { 16965, "INV_Boots_Plate_04", "=q4=Sabatons of Wrath", "=ds="..AtlasLootBossNames["BlackwingLair"][3], "16.84%" },
        };

-- Tier 1 Sets (T1)


    T1Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#t1s1#", "" },
	{ 16834, "INV_Helmet_09", "=q4=Cenarion Helm", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.51%" },
	{ 16836, "INV_Shoulder_07", "=q4=Cenarion Spaulders", "=ds="..AtlasLootBossNames["MoltenCore"][6], "19.52%" },
        { 16833, "INV_Chest_Cloth_06", "=q4=Cenarion Vestments", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.21%" },
        { 16830, "INV_Bracer_03", "=q4=Cenarion Bracers", "=ds="..AtlasLootBossNames["Common"][1], "0.17%" },
        { 16831, "INV_Gauntlets_07", "=q4=Cenarion Gloves", "=ds="..AtlasLootBossNames["MoltenCore"][5], "19.53%" },
	{ 16828, "INV_Belt_06", "=q4=Cenarion Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16835, "INV_Pants_06", "=q4=Cenarion Leggings", "=ds="..AtlasLootBossNames["MoltenCore"][2], "12.90%" },
        { 16829, "INV_Boots_08", "=q4=Cenarion Boots", "=ds="..AtlasLootBossNames["MoltenCore"][1], "10.72%" },
	};
        
    T1Hunter = {
	{ 0, "Ability_Hunter_RunningShot", "=q6=#t1s2#", "" },
	{ 16846, "INV_Helmet_05", "=q4=Giantstalker's Helmet", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.57%" },
	{ 16848, "INV_Shoulder_10", "=q4=Giantstalker's Epaulets", "=ds="..AtlasLootBossNames["MoltenCore"][8], "19.64%" },
        { 16845, "INV_Chest_Chain_03", "=q4=Giantstalker's Breastplate", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.83%" },
	{ 16850, "INV_Bracer_17", "=q4=Giantstalker's Bracers", "=ds="..AtlasLootBossNames["Common"][1], "0.18%" },
        { 16852, "INV_Gauntlets_10", "=q4=Giantstalker's Gloves", "=ds="..AtlasLootBossNames["MoltenCore"][5], "18.58%" },
        { 16851, "INV_Belt_28", "=q4=Giantstalker's Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.17%" },
        { 16847, "INV_Pants_Mail_03", "=q4=Giantstalker's Leggings", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.28%" },
	{ 16849, "INV_Boots_Chain_13", "=q4=Giantstalker's Boots", "=ds="..AtlasLootBossNames["MoltenCore"][3], "14.54%" },
	};

    T1Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#t1s3#", "" },
        { 16795, "INV_Helmet_53", "=q4=Arcanist Crown", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.31%" },
        { 16797, "INV_Shoulder_02", "=q4=Arcanist Mantle", "=ds="..AtlasLootBossNames["MoltenCore"][6], "19.92%" },
        { 16798, "INV_Chest_Cloth_03", "=q4=Arcanist Robes", "=ds="..AtlasLootBossNames["MoltenCore"][7], "16.51%" },
        { 16799, "INV_Belt_29", "=q4=Arcanist Bindings", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16801, "INV_Gauntlets_14", "=q4=Arcanist Gloves", "=ds="..AtlasLootBossNames["MoltenCore"][5], "19.59%" },
        { 16802, "INV_Belt_30", "=q4=Arcanist Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.16%"  },
        { 16796, "INV_Pants_08", "=q4=Arcanist Leggings", "=ds="..AtlasLootBossNames["MoltenCore"][2], "14.57%" },
        { 16800, "INV_Boots_07", "=q4=Arcanist Boots",  "=ds="..AtlasLootBossNames["MoltenCore"][1], "12.06%" },
        };

    T1Paladin = {
	{ 0, "Spell_Holy_SealOfMight", "=q6=#t1s4#", "" },
	{ 16854, "INV_Helmet_05", "=q4=Lawbringer Helm", "=ds="..AtlasLootBossNames["MoltenCore"][4], "7.23%" },
	{ 16856, "INV_Shoulder_20", "=q4=Lawbringer Spaulders", "=ds="..AtlasLootBossNames["MoltenCore"][6], "12.62%" },
	{ 16853, "INV_Chest_Plate03", "=q4=Lawbringer Chestguard", "=ds="..AtlasLootBossNames["MoltenCore"][7], "9.53%" },
	{ 16857, "INV_Bracer_18", "=q4=Lawbringer Bracers", "=ds="..AtlasLootBossNames["Common"][1], "0.11%" },
        { 16860, "INV_Gauntlets_29", "=q4=Lawbringer Gauntlets", "=ds="..AtlasLootBossNames["MoltenCore"][3], "11.77%" },
        { 16858, "INV_Belt_27", "=q4=Lawbringer Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.10%" },
        { 16855, "INV_Pants_04", "=q4=Lawbringer Legplates", "=ds="..AtlasLootBossNames["MoltenCore"][2], "8.54%" },
        { 16859, "INV_Boots_Plate_09", "=q4=Lawbringer Boots", "=ds="..AtlasLootBossNames["MoltenCore"][1], "7.20%" },
	};

    T1Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t1s5#", "" },
        { 16813, "INV_Helmet_34", "=q4=Circlet of Prophecy", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.36%" },
        { 16816, "INV_Shoulder_02", "=q4=Mantle of Prophecy", "=ds="..AtlasLootBossNames["MoltenCore"][8], "21.06%" },
        { 16815, "INV_Chest_Cloth_03", "=q4=Robes of Prophecy", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.65%" },
        { 16819, "INV_Bracer_09", "=q4=Vambraces of Prophecy",   "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16812, "INV_Gauntlets_14", "=q4=Gloves of Prophecy", "=ds="..AtlasLootBossNames["MoltenCore"][3], "18.65%" },
        { 16817, "INV_Belt_22", "=q4=Girdle of Prophecy", "=ds="..AtlasLootBossNames["Common"][1], "0.18%" },
        { 16814, "INV_Pants_08", "=q4=Pants of Prophecy", "=ds="..AtlasLootBossNames["MoltenCore"][2], "14.33%" },
        { 16811, "INV_Gauntlets_07", "=q4=Boots of Prophecy", "=ds="..AtlasLootBossNames["MoltenCore"][5], "14.90%" },
        };

    T1Rogue = {
        { 0, "Ability_BackStab", "=q6=#t1s6#", "" },
        { 16821, "INV_Helmet_41", "=q4=Nightslayer Cover", "=ds="..AtlasLootBossNames["MoltenCore"][4], "10.38%" },
        { 16823, "INV_Shoulder_25", "=q4=Nightslayer Shoulder Pads", "=ds="..AtlasLootBossNames["MoltenCore"][8], "20.66%" },
        { 16820, "INV_Chest_Cloth_07", "=q4=Nightslayer Chestpiece", "=ds="..AtlasLootBossNames["MoltenCore"][7], "16.76%" },
        { 16825, "INV_Bracer_02", "=q4=Nightslayer Bracelets", "=ds="..AtlasLootBossNames["Common"][1], "0.17%" },
        { 16826, "INV_Gauntlets_21", "=q4=Nightslayer Gloves", "=ds="..AtlasLootBossNames["MoltenCore"][3], "19.47%" },
        { 16827, "INV_Belt_23", "=q4=Nightslayer Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.15%" },
        { 16822, "INV_Pants_06", "=q4=Nightslayer Pants", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.83%" },
        { 16824, "INV_Gauntlets_08", "=q4=Nightslayer Boots", "=ds="..AtlasLootBossNames["MoltenCore"][5], "15.58%" },
        };

    T1Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t1s7#", "" },
        { 16842, "INV_Helmet_09", "=q4=Earthfury Helmet", "=ds="..AtlasLootBossNames["MoltenCore"][4], "3.91%" },
        { 16844, "INV_Shoulder_29", "=q4=Earthfury Epaulets", "=ds="..AtlasLootBossNames["MoltenCore"][6], "7.29%" },
        { 16841, "INV_Chest_Chain_11", "=q4=Earthfury Vestments", "=ds="..AtlasLootBossNames["MoltenCore"][7], "6.08%" },
        { 16840, "INV_Bracer_16", "=q4=Earthfury Bracers", "=ds="..AtlasLootBossNames["Common"][1], "0.06%" },
        { 16839, "INV_Gauntlets_11", "=q4=Earthfury Gauntlets", "=ds="..AtlasLootBossNames["MoltenCore"][3], "7.38%" },
        { 16838, "INV_Belt_14", "=q4=Earthfury Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.07%" },
        { 16843, "INV_Pants_03", "=q4=Earthfury Legguards", "=ds="..AtlasLootBossNames["MoltenCore"][2], "4.73%" },
        { 16837, "INV_Boots_Plate_06", "=q4=Earthfury Boots", "=ds="..AtlasLootBossNames["MoltenCore"][1], "4.16%" },
        };

    T1Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t1s8#", "" },
        { 16808, "INV_Helmet_08", "=q4=Felheart Horns", "=ds="..AtlasLootBossNames["MoltenCore"][4], "10.62%" },
        { 16807, "INV_Shoulder_23", "=q4=Felheart Shoulder Pads", "=ds="..AtlasLootBossNames["MoltenCore"][6], "19.78%" },
        { 16809, "INV_Chest_Cloth_09", "=q4=Felheart Robes", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.66%" },
        { 16804, "INV_Bracer_07", "=q4=Felheart Bracers", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16805, "INV_Gauntlets_19", "=q4=Felheart Gloves", "=ds="..AtlasLootBossNames["MoltenCore"][1],  "14.89%" },
        { 16806, "INV_Belt_13", "=q4=Felheart Belt", "=ds="..AtlasLootBossNames["Common"][1], "0.19%" },
        { 16810, "INV_Pants_Cloth_14", "=q4=Felheart Pants", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.75%" },
        { 16803, "INV_Boots_Cloth_05", "=q4=Felheart Slippers", "=ds="..AtlasLootBossNames["MoltenCore"][5], "15.28%" },
        };

    T1Warrior = {
        { 0, "INV_Shield_05", "=q6=#t1s9#", "" },
        { 16866, "INV_Helmet_09", "=q4=Helm of Might", "=ds="..AtlasLootBossNames["MoltenCore"][4], "11.39%" },
        { 16868, "INV_Shoulder_15", "=q4=Pauldrons of Might", "=ds="..AtlasLootBossNames["MoltenCore"][8], "21.14%" },
        { 16865, "INV_Chest_Plate16", "=q4=Breastplate of Might", "=ds="..AtlasLootBossNames["MoltenCore"][7], "15.28%" },
        { 16861, "INV_Bracer_19", "=q4=Bracers of Might", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16863, "INV_Gauntlets_10", "=q4=Gauntlets of Might", "=ds="..AtlasLootBossNames["MoltenCore"][1],  "16.40%" },
        { 16864, "INV_Belt_09", "=q4=Belt of Might", "=ds="..AtlasLootBossNames["Common"][1], "0.16%" },
        { 16867, "INV_Pants_04", "=q4=Legplates of Might", "=ds="..AtlasLootBossNames["MoltenCore"][2], "13.97%" },
        { 16862, "INV_Boots_Plate_04", "=q4=Sabatons of Might", "=ds="..AtlasLootBossNames["MoltenCore"][3], "14.48%" },
        };

-- Dungeon 1 and 2 Sets (D1/D2)

    T0Druid = {
	{ 0, "Spell_Nature_Regeneration", "=q6=#t0s1#", "=ec1=#j6#" },
        { 16720, "INV_Helmet_27", "=q3=Wildheart Cowl", "=ds="..AtlasLootBossNames["Scholomance"][16], "7.09%" },
        { 16718, "INV_Shoulder_01", "=q3=Wildheart Spaulders",  "=ds="..AtlasLootBossNames["BlackrockSpireLower"][10], "11.04%" },
        { 16706,"INV_Chest_Plate06","=q3=Wildheart Vest", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "7.36%" },
        { 16714, "INV_Bracer_09", "=q3=Wildheart Bracers", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.85%" },
	{ 16717, "INV_Gauntlets_17", "=q3=Wildheart Gloves", "=ds="..AtlasLootBossNames["Stratholme"][5], "12.61%" },
        { 16716, "INV_Belt_15", "=q3=Wildheart Belt", "=ds="..AtlasLootBossNames["Scholomance"][17], "2.60%" },
	{ 16719, "INV_Pants_08", "=q3=Wildheart Kilt", "=ds="..AtlasLootBossNames["Stratholme"][18], "6.58%" },
        { 16715, "INV_Boots_08", "=q3=Wildheart Boots", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][6], "13.03%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Nature_Regeneration", "=q6=#t05s1#", "=ec1=#j7#" },
        { 22109, "INV_Helmet_27", "=q4=Feralheart Cowl", "=ds=#a2#, #s1#" },
	{ 22112, "INV_Shoulder_01", "=q3=Feralheart Spaulders",  "=ds=#a2#, #s3#" },
	{ 22113,"INV_Chest_Plate06","=q4=Feralheart Vest", "=ds=#a2#, #s5#" },
        { 22108, "INV_Bracer_09", "=q3=Feralheart Bracers", "=ds=#a2#, #s8#" },
	{ 22110, "INV_Gauntlets_17", "=q4=Feralheart Gloves", "=ds=#a2#, #s9#" },
        { 22106, "INV_Belt_15", "=q3=Feralheart Belt", "=ds=#a2#, #s10#" },
	{ 22111, "INV_Pants_08", "=q3=Feralheart Kilt", "=ds=#a2#, #s11#" },
        { 22107, "INV_Boots_08", "=q4=Feralheart Boots", "=ds=#a2#, #s12#" },
	};

    T0Hunter = {
	{ 0, "Ability_Hunter_RunningShot", "=q6=#t0s2#", "=ec1=#j6#" },
        { 16677, "INV_Helmet_24", "=q3=Beaststalker's Cap", "=ds="..AtlasLootBossNames["Scholomance"][16], "7.00%" },
	{ 16679, "INV_Shoulder_10", "=q3=Beaststalker's Mantle", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][12], "9.89%" },
	{ 16674, "INV_Chest_Chain_03","=q3=Beaststalker's Tunic", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10],   "6.81%" },
	{ 16681, "INV_Bracer_17", "=q3=Beaststalker's Bindings", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.64%" },
        { 16676, "INV_Gauntlets_10", "=q3=Beaststalker's Gloves", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][4], "9.15%" },
        { 16680, "INV_Belt_28", "=q3=Beaststalker's Belt", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.36%" },
        { 16678, "INV_Pants_03", "=q3=Beaststalker's Pants", "=ds="..AtlasLootBossNames["Stratholme"][18], "6.16%" },
        { 16675, "INV_Boots_Plate_07", "=q3=Beaststalker's Boots", "=ds="..AtlasLootBossNames["Stratholme"][14], "13.62%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Ability_Hunter_RunningShot", "=q6=#t05s2#", "=ec1=#j7#" },
        { 22013, "INV_Helmet_24", "=q4=Beastmaster's Cap", "=ds=#a3#, #s1#" },
	{ 22016, "INV_Shoulder_10", "=q3=Beastmaster's Mantle", "=ds=#a3#, #s3#" },
	{ 22060, "INV_Chest_Chain_03","=q4=Beastmaster's Tunic", "=ds=#a3#, #s5#" },
	{ 22011, "INV_Bracer_17", "=q3=Beastmaster's Bindings", "=ds=#a3#, #s8#" },
        { 22015, "INV_Gauntlets_10", "=q4=Beastmaster's Gloves", "=ds=#a3#, #s9#" },
        { 22010, "INV_Belt_28", "=q3=Beastmaster's Belt", "=ds=#a3#, #s10#" },
        { 22017, "INV_Pants_03", "=q3=Beastmaster's Pants", "=ds=#a3#, #s11#" },
        { 22061, "INV_Boots_Plate_07", "=q4=Beastmaster's Boots", "=ds=#a3#, #s12#" },
	};
        
    T0Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#t0s3#", "=ec1=#j6#" },
        { 16686, "INV_Crown_02", "=q3=Magister's Crown", "=ds="..AtlasLootBossNames["Scholomance"][16], "8.60%" },
        { 16689, "INV_Shoulder_23", "=q3=Magister's Mantle", "=ds="..AtlasLootBossNames["Scholomance"][8], "11.93%" },
        { 16688,"INV_Chest_Cloth_25","=q3=Magister's Robes", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "7.24%" },
        { 16683, "INV_Jewelry_Ring_23", "=q3=Magister's Bindings", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.19%" },
        { 16684, "INV_Gauntlets_17", "=q3=Magister's Gloves", "=ds="..AtlasLootBossNames["Scholomance"][11], "9.75%" },
        { 16685, "INV_Belt_08", "=q3=Magister's Belt", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.32%" },
        { 16687, "INV_Pants_06", "=q3=Magister's Leggings", "=ds="..AtlasLootBossNames["Stratholme"][18], "6.79%" },
        { 16682, "INV_Boots_02", "=q3=Magister's Boots", "=ds="..AtlasLootBossNames["Stratholme"][4], "10.86%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Frost_IceStorm", "=q6=#t05s3#", "=ec1=#j7#" },
        { 22065, "INV_Crown_02", "=q4=Sorcerer's Crown", "=ds=#a1#, #s1#" },
        { 22068, "INV_Shoulder_23", "=q3=Sorcerer's Mantle", "=ds=#a1#, #s3#" },
        { 22069, "INV_Chest_Cloth_25","=q4=Sorcerer's Robes", "=ds=#a1#, #s5#" },
        { 22063, "INV_Jewelry_Ring_23", "=q3=Sorcerer's Bindings", "=ds=#a1#, #s8#" },
        { 22066, "INV_Gauntlets_17", "=q4=Sorcerer's Gloves", "=ds=#a1#, #s9#" },
        { 22062, "INV_Belt_08", "=q3=Sorcerer's Belt", "=ds=#a1#, #s10#" },
        { 22067, "INV_Pants_06", "=q3=Sorcerer's Leggings", "=ds=#a1#, #s11#" },
        { 22064, "INV_Boots_02", "=q4=Sorcerer's Boots", "=ds=#a1#, #s12#" },
        };

    T0Paladin = {
	{ 0, "Spell_Holy_SealOfMight", "=q6=#t0s4#", "=ec1=#j6#" },
        { 16727, "INV_Helmet_08", "=q3=Lightforge Helm", "=ds="..AtlasLootBossNames["Scholomance"][16], "5.32%" },
	{ 16729,"INV_Shoulder_10","=q3=Lightforge Spaulders", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][8], "13.62%" },
        { 16726,"INV_Chest_Plate03","=q3=Lightforge Breastplate", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "3.76%" },
        { 16722, "INV_Bracer_14", "=q3=Lightforge Bracers", "=ds="..AtlasLootBossNames["Scholomance"][17], "3.37%" },
        { 16724, "INV_Gauntlets_19", "=q3=Lightforge Gauntlets", "=ds="..AtlasLootBossNames["Stratholme"][6], "10.42%" },
        { 16723, "INV_Belt_11", "=q3=Lightforge Belt", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.93%" },
        { 16728, "INV_Pants_04", "=q3=Lightforge Legplates", "=ds="..AtlasLootBossNames["Stratholme"][18], "4.20%" },
	{ 16725, "INV_Boots_Plate_03", "=q3=Lightforge Boots", "=ds="..AtlasLootBossNames["Stratholme"][9], "11.11%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_SealOfMight", "=q6=#t05s4#", "=ec1=#j7#" },
        { 22091, "INV_Helmet_08", "=q4=Soulforge Helm", "=ds=#a4#, #s1#" },
	{ 22093, "INV_Shoulder_10","=q3=Soulforge Spaulders", "=ds=#a4#, #s3#" },
        { 22089, "INV_Chest_Plate03","=q4=Soulforge Breastplate", "=ds=#a4#, #s5#" },
	{ 22088, "INV_Bracer_14", "=q3=Soulforge Bracers", "=ds=#a4#, #s8#" },
        { 22090, "INV_Gauntlets_19", "=q4=Soulforge Gauntlets", "=ds=#a4#, #s9#" },
        { 22086, "INV_Belt_11", "=q3=Soulforge Belt", "=ds=#a4#, #s10#" },
        { 22092, "INV_Pants_04", "=q3=Soulforge Legplates", "=ds=#a4#, #s11#" },
	{ 22087, "INV_Boots_Plate_03", "=q4=Soulforge Boots", "=ds=#a4#, #s12#" },
	};

    T0Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t0s5#", "=ec1=#j6#" },
        { 16693, "INV_Crown_01", "=q3=Devout Crown", "=ds="..AtlasLootBossNames["Scholomance"][16], "7.89%" },
        { 16695, "INV_Shoulder_02", "=q3=Devout Mantle", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][2], "12.84%" },
        { 16690,"INV_Chest_Cloth_11","=q3=Devout Robe", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "6.20%" },
        { 16697, "INV_Belt_31", "=q3=Devout Bracers", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.13%" },
        { 16692, "INV_Gauntlets_14", "=q3=Devout Gloves", "=ds="..AtlasLootBossNames["Stratholme"][8], "12.46%" },
        { 16696, "INV_Belt_10", "=q3=Devout Belt", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "2.07%" },
        { 16694, "INV_Pants_08", "=q3=Devout Skirt", "=ds="..AtlasLootBossNames["Stratholme"][18], "7.42%" },
        { 16691, "INV_Boots_05", "=q3=Devout Sandals", "=ds="..AtlasLootBossNames["Stratholme"][15], "13.64%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Holy_PowerWordShield", "=q6=#t05s5#", "=ec1=#j7#" },
        { 22080, "INV_Crown_01", "=q4=Virtuous Crown", "=ds=#a1#, #s1#" },
        { 22082, "INV_Shoulder_02", "=q3=Virtuous Mantle", "=ds=#a1#, #s3#" },
        { 22083,"INV_Chest_Cloth_11","=q4=Virtuous Robe", "=ds=#a1#, #s5#" },
        { 22079, "INV_Belt_31", "=q3=Virtuous Bracers", "=ds=#a1#, #s8#" },
        { 22081, "INV_Gauntlets_14", "=q4=Virtuous Gloves", "=ds=#a1#, #s9#" },
        { 22078, "INV_Belt_10", "=q3=Virtuous Belt", "=ds=#a1#, #s10#" },
        { 22085, "INV_Pants_08", "=q3=Virtuous Skirt", "=ds=#a1#, #s11#" },
        { 22084, "INV_Boots_05", "=q4=Virtuous Sandals", "=ds=#a1#, #s12#" },
        };

    T0Rogue = {
        { 0, "Ability_BackStab", "=q6=#t0s6#", "=ec1=#j6#" },
        { 16707, "INV_Helmet_41", "=q3=Shadowcraft Cap", "=ds="..AtlasLootBossNames["Scholomance"][16], "6.65%" },
        { 16708, "INV_Shoulder_07", "=q3=Shadowcraft Spaulders", "=ds="..AtlasLootBossNames["Stratholme"][7], "10.68%" },
        { 16721,"INV_Chest_Leather_07","=q3=Shadowcraft Tunic",  "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "6.09%" },
        { 16710, "INV_Bracer_07", "=q3=Shadowcraft Bracers", "=ds="..AtlasLootBossNames["Scholomance"][17], "3.51%" },
        { 16712, "INV_Gauntlets_24", "=q3=Shadowcraft Gloves", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][3], "11.89%" },
        { 16713, "INV_Belt_03", "=q3=Shadowcraft Belt", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.05%" },
        { 16709, "INV_Pants_02", "=q3=Shadowcraft Pants", "=ds="..AtlasLootBossNames["Stratholme"][18], "7.76%" },
        { 16711, "INV_Boots_08", "=q3=Shadowcraft Boots", "=ds="..AtlasLootBossNames["Scholomance"][4], "14.32%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Ability_BackStab", "=q6=#t05s6#", "=ec1=#j7#" },
        { 22005, "INV_Helmet_41", "=q4=Darkmantle Cap", "=ds=#a2#, #s1#" },
        { 22008, "INV_Shoulder_07", "=q3=Darkmantle Spaulders", "=ds=#a2#, #s3#" },
        { 22009,"INV_Chest_Leather_07","=q4=Darkmantle Tunic",  "=ds=#a2#, #s5#" },
        { 22004, "INV_Bracer_07", "=q3=Darkmantle Bracers", "=ds=#a2#, #s8#" },
        { 22006, "INV_Gauntlets_24", "=q4=Darkmantle Gloves", "=ds=#a2#, #s9#" },
        { 22002, "INV_Belt_03", "=q3=Darkmantle Belt", "=ds=#a2#, #s10#" },
        { 22007, "INV_Pants_02", "=q3=Darkmantle Pants", "=ds=#a2#, #s11#" },
        { 22003, "INV_Boots_08", "=q4=Darkmantle Boots", "=ds=#a2#, #s12#" },
        };

    T0Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t0s7#", "=ec1=#j6#" },
        { 16667, "INV_Helmet_04", "=q3=Coif of Elements", "=ds="..AtlasLootBossNames["Scholomance"][16], "2.86%" },
        { 16669,"INV_Shoulder_29","=q3=Pauldrons of Elements","=ds="..AtlasLootBossNames["BlackrockSpireUpper"][7], "14.77%" },
        { 16666,"INV_Chest_Chain_11","=q3=Vest of Elements", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "3.03%" },
        { 16671, "INV_Bracer_02", "=q3=Bindings of Elements", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.59%" },
        { 16672,"INV_Gauntlets_11","=q3=Gauntlets of Elements", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][1], "14.23%" },
        { 16673, "INV_Belt_16", "=q3=Cord of Elements", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.06%" },
        { 16668, "INV_Pants_03", "=q3=Kilt of Elements", "=ds="..AtlasLootBossNames["Stratholme"][18], "3.02%" },
        { 16670, "INV_Boots_Wolf", "=q3=Boots of Elements", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][1], "9.35%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_FireResistanceTotem_01", "=q6=#t05s7#", "=ec1=#j7#" },
        { 22097, "INV_Helmet_04", "=q4=Coif of The Five Thunders", "=ds=#a3#, #s1#" },
        { 22101,"INV_Shoulder_29","=q3=Pauldrons of The Five Thunders","=ds=#a3#, #s3#" },
        { 22102,"INV_Chest_Chain_11","=q4=Vest of The Five Thunders", "=ds=#a3#, #s5#" },
        { 22095, "INV_Bracer_02", "=q3=Bindings of The Five Thunders", "=ds=#a3#, #s8#" },
        { 22099,"INV_Gauntlets_11","=q4=Gauntlets of The Five Thunders", "=ds=#a3#, #s9#" },
        { 22098, "INV_Belt_16", "=q3=Cord of The Five Thunders", "=ds=#a3#, #s10#" },
        { 22100, "INV_Pants_03", "=q3=Kilt of The Five Thunders", "=ds=#a3#, #s11#" },
        { 22096, "INV_Boots_Wolf", "=q4=Boots of The Five Thunders", "=ds=#a3#, #s12#" },
        };

    T0Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t0s8#", "=ec1=#j6#" },
        { 16698, "INV_Helmet_29", "=q3=Dreadmist Mask", "=ds="..AtlasLootBossNames["Scholomance"][16], "8.78%" },
        { 16701, "INV_Misc_Bone_TaurenSkull_01", "=q3=Dreadmist Mantle", "=ds="..AtlasLootBossNames["Scholomance"][3], "12.20%" },
        { 16700, "INV_Chest_Cloth_49","=q3=Dreadmist Robe", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "8.04%" },
        { 16703, "INV_Bracer_13", "=q3=Dreadmist Bracers", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.68%" },
        { 16705, "INV_Gauntlets_32", "=q3=Dreadmist Wraps", "=ds="..AtlasLootBossNames["Scholomance"][12], "14.54%" },
        { 16702, "INV_Belt_12", "=q3=Dreadmist Belt", "=ds="..AtlasLootBossNames["Stratholme"][19], "1.03%" },
        { 16699, "INV_Pants_08", "=q3=Dreadmist Leggings", "=ds="..AtlasLootBossNames["Stratholme"][18], "7.31%" },
        { 16704, "INV_Boots_05", "=q3=Dreadmist Sandals", "=ds="..AtlasLootBossNames["Stratholme"][13], "13.16%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#t05s8#", "=ec1=#j7#" },
        { 22074, "INV_Helmet_29", "=q4=Deathmist Mask", "=ds=#a1#, #s1#" },
        { 22073, "INV_Misc_Bone_TaurenSkull_01", "=q3=Deathmist Mantle", "=ds=#a1#, #s5#" },
        { 22075, "INV_Chest_Cloth_49","=q4=Deathmist Robe", "=ds=#a1#, #s3#" },
        { 22071, "INV_Bracer_13", "=q3=Deathmist Bracers", "=ds=#a1#, #s8#" },
        { 22077, "INV_Gauntlets_32", "=q4=Deathmist Wraps", "=ds=#a1#, #s9#" },
        { 22070, "INV_Belt_12", "=q3=Deathmist Belt", "=ds=#a1#, #s10#" },
        { 22072, "INV_Pants_08", "=q3=Deathmist Leggings", "=ds=#a1#, #s11#" },
        { 22076, "INV_Boots_05", "=q4=Deathmist Sandals", "=ds=#a1#, #s12#" },
        };

    T0Warrior = {
        { 0, "INV_Shield_05", "=q6=#t0s9#", "=ec1=#j6#" },
        { 16731, "INV_Helmet_02", "=q3=Helm of Valor", "=ds="..AtlasLootBossNames["Scholomance"][16], "6.54%" },
        { 16733,"INV_Shoulder_30","=q3=Spaulders of Valor","=ds="..AtlasLootBossNames["BlackrockSpireUpper"][6], "13.39%" },
        { 16730,"INV_Chest_Plate03","=q3=Breastplate of Valor", "=ds="..AtlasLootBossNames["BlackrockSpireUpper"][10], "5.83%" },
        { 16735, "INV_Bracer_18", "=q3=Bracers of Valor", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.49%" },
        { 16737, "INV_Gauntlets_26", "=q3=Gauntlets of Valor", "=ds="..AtlasLootBossNames["Stratholme"][17], "9.58%" },
        { 16736, "INV_Belt_34", "=q3=Belt of Valor", "=ds="..AtlasLootBossNames["BlackrockSpireLower"][15], "1.96%" },
        { 16732, "INV_Pants_04", "=q3=Legplates of Valor", "=ds="..AtlasLootBossNames["Stratholme"][18], "5.74%" },
        { 16734, "INV_Boots_Plate_03", "=q3=Boots of Valor", "=ds="..AtlasLootBossNames["Scholomance"][2], "11.12%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Shield_05", "=q6=#t05s9#", "=ec1=#j7#" },
        { 21999, "INV_Helmet_02", "=q4=Helm of Heroism", "=ds=#a4#, #s1#" },
        { 22001,"INV_Shoulder_30","=q3=Spaulders of Heroism","=ds=#a4#, #s3#" },
        { 21997,"INV_Chest_Plate03","=q4=Breastplate of Heroism", "=ds=#a4#, #s5#" },
        { 21996, "INV_Bracer_18", "=q3=Bracers of Heroism", "=ds=#a4#, #s8#" },
        { 21998, "INV_Gauntlets_26", "=q4=Gauntlets of Heroism", "=ds=#a4#, #s9#" },
        { 21994, "INV_Belt_34", "=q3=Belt of Heroism", "=ds=#a4#, #s10#" },
        { 22000, "INV_Pants_04", "=q3=Legplates of Heroism", "=ds=#a4#, #s11#" },
        { 21995, "INV_Boots_Plate_03", "=q4=Boots of Heroism", "=ds=#a4#, #s12#" },
        };

-- Dungeon 3 Sets (D3)

    DS3Hallowed = {
        { 28413, "INV_Jewelry_Ring_62", "=q3=Hallowed Crown", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27775, "INV_Shoulder_22", "=q3=Hallowed Pauldrons", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][3] },
        { 28230, "INV_Chest_Cloth_39", "=q3=Hallowed Garments", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 27536, "INV_Gauntlets_27", "=q3=Hallowed Handwraps", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27875, "INV_Pants_Cloth_18", "=q3=Hallowed Trousers", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };

    DS3Incanter = {
        { 28278, "INV_Helmet_34", "=q3=Incanter's Cowl", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27738, "INV_Shoulder_02", "=q3=Incanter's Pauldrons", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 28229, "INV_Chest_Cloth_25", "=q3=Incanter's Robe", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27508, "INV_Gauntlets_17", "=q3=Incanter's Gloves", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][1] },
        { 27838, "INV_Pants_Cloth_20", "=q3=Incanter's Trousers", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };
    
    DS3Mana = {
        { 28193, "INV_Jewelry_Ring_56", "=q3=Mana-Etched Crown", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        { 27796, "INV_Shoulder_22", "=q3=Mana-Etched Spaulders", "=ds="..AtlasLootBossNames["CFRTheSlavePens"][3].." (#j3#)" },
        { 28191, "INV_Chest_Cloth_42", "=q3=Mana-Etched Vestments", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27465, "INV_Gauntlets_15", "=q3=Mana-Etched Gloves", "=ds="..AtlasLootBossNames["HCRamparts"][2].." (#j3#)" },
        { 27907, "INV_Pants_Cloth_17", "=q3=Mana-Etched Pantaloons", "=ds="..AtlasLootBossNames["CFRTheUnderbog"][4].." (#j3#)" },
        };
        
    DS3Oblivion = {
        { 28415, "INV_Helmet_30", "=q3=Hood of Oblivion", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27778, "INV_Shoulder_18", "=q3=Spaulders of Oblivion", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 28232, "INV_Chest_Cloth_29", "=q3=Robe of Oblivion", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 27537, "INV_Gauntlets_16", "=q3=Gloves of Oblivion", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27948, "INV_Pants_08", "=q3=Trousers of Oblivion", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };
        
    DS3Assassin = {
        { 28414, "INV_Helmet_15", "=q3=Helm of Assassination", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27776, "INV_Shoulder_24", "=q3=Shoulderpads of Assassination", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        { 28204, "INV_Chest_Chain_17", "=q3=Tunic of Assassination", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27509, "INV_Gauntlets_01", "=q3=Handgrips of Assassination", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        { 27908, "INV_Pants_Leather_03", "=q3=Leggings of Assassination", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        };
        
    DS3Moonglade = {
        { 28348, "INV_Helmet_15", "=q3=Moonglade Cowl", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27737, "INV_Shoulder_24", "=q3=Moonglade Shoulders", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 28202, "INV_Chest_Cloth_07", "=q3=Moonglade Robe", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27468, "INV_Gauntlets_13", "=q3=Moonglade Handwraps", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][2] },
        { 27873, "INV_Pants_14", "=q3=Moonglade Pants", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        };
        
    DS3Wastewalker = {
        { 28224, "INV_Helmet_15", "=q3=Wastewalker Helm", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27797, "INV_Shoulder_15", "=q3=Wastewalker Shoulderpads", "=ds="..AtlasLootBossNames["AuchAuchenaiCrypts"][3].." (#j3#)" },
        { 28264, "INV_Chest_Chain_17", "=q3=Wastewalker Tunic", "=ds="..AtlasLootBossNames["HCBloodFurnace"][3].." (#j3#)" },
        { 27531, "INV_Gauntlets_25", "=q3=Wastewalker Gloves", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27837, "INV_Pants_Mail_04", "=q3=Wastewalker Leggings", "=ds="..AtlasLootBossNames["AuchManaTombs"][3].." (#j3#)" },
        };
        
    DS3Beast = {
        { 28275, "INV_Helmet_19", "=q3=Beast Lord Helm", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27801, "INV_Shoulder_23", "=q3=Beast Lord Mantle", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 28228, "INV_Chest_Chain_03", "=q3=Beast Lord Curiass", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27474, "INV_Gauntlets_10", "=q3=Beast Lord Handguards", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27874, "INV_Pants_03", "=q3=Beast Lord Leggings", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        };
        
    DS3Desolation = {
        { 28192, "INV_Helmet_18", "=q3=Helm of Desolation", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        { 27713, "INV_Shoulder_20", "=q3=Pauldrons of Desolation", "=ds="..AtlasLootBossNames["CFRTheSlavePens"][3].." (#j3#)" },
        { 28401, "INV_Chest_Chain_03", "=q3=Hauberk of Desolation", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27528, "INV_Gauntlets_10", "=q3=Gauntlets of Desolation", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 27936, "INV_Pants_Cloth_20", "=q3=Greaves of Desolation", "=ds="..AtlasLootBossNames["AuchSethekkHalls"][2] },
        };
        
    DS3Tidefury = {
        { 28349, "INV_Helmet_19", "=q3=Tidefury Helm", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27802, "INV_Shoulder_31", "=q3=Tidefury Shoulderguards", "=ds="..AtlasLootBossNames["HCShatteredHalls"][3] },
        { 28231, "INV_Chest_Chain_03", "=q3=Tidefury Chestpiece", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27510, "INV_Gauntlets_10", "=q3=Tidefury Gauntlets", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 27909, "INV_Pants_Mail_06", "=q3=Tidefury Kilt", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        };
        
    DS3Bold = {
        { 28350, "INV_Helmet_20", "=q3=Warhelm of the Bold", "=ds="..AtlasLootBossNames["TKTheBotanica"][5] },
        { 27803, "INV_Shoulder_26", "=q3=Shoulderguards of the Bold", "=ds="..AtlasLootBossNames["AuchShadowLabyrinth"][4] },
        { 28205, "INV_Chest_Chain_15", "=q3=Breastplate of the Bold", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27475, "INV_Gauntlets_28", "=q3=Gauntlets of the Bold", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 27977, "INV_Pants_Plate_06", "=q3=Legplates of the Bold", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        };
        
    DS3Doom = {
        { 28225, "INV_Helmet_20", "=q3=Doomplate Warhelm", "=ds="..AtlasLootBossNames["CoTOldHillsbradFoothills"][3].." (#j3#)" },
        { 27771, "INV_Shoulder_26", "=q3=Doomplate Shouldergards", "=ds="..AtlasLootBossNames["CFRTheUnderbog"][4].." (#j3#)" },
        { 28403, "INV_Chest_Chain_15", "=q3=Doomplate Chestguard", "=ds="..AtlasLootBossNames["TKTheArcatraz"][4] },
        { 27497, "INV_Gauntlets_29", "=q3=Doomplate Gauntlets", "=ds="..AtlasLootBossNames["HCBloodFurnace"][3].." (#j3#)" },
        { 27870, "INV_Pants_Plate_12", "=q3=Doomplate Legguards", "=ds="..AtlasLootBossNames["AuchAuchenaiCrypts"][2].." (#j3#)" },
        };
        
    DS3Right = {
        { 28285, "INV_Helmet_25", "=q3=Helm of the Righteous", "=ds="..AtlasLootBossNames["TKMechanar"][5] },
        { 27739, "INV_Shoulder_10", "=q3=Spaulders of the Righteous", "=ds="..AtlasLootBossNames["TKTheBotanica"][4] },
        { 28203, "INV_Chest_Chain_15", "=q3=Breastplate of the Righteous", "=ds="..AtlasLootBossNames["CFRTheSteamvault"][3] },
        { 27535, "INV_Gauntlets_29", "=q3=Gauntlets of the Righteous", "=ds="..AtlasLootBossNames["HCShatteredHalls"][2] },
        { 27839, "INV_Pants_04", "=q3=Legplates of the Righteous", "=ds="..AtlasLootBossNames["CoTTheBlackMorass"][3] },
        };

-- ZG Sets

    ZGDruid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#zgs1#", "" },
        { 19955, "INV_Jewelry_Necklace_19", "=q4=Wushoolay's Charm of Nature", "" },
        { 19613, "INV_Jewelry_Necklace_26", "=q4=Pristine Enchanted South Seas Kelp", "=ds=#r5#" },
        { 19838, "INV_Chest_Leather_06", "=q4=Zandalar Haruspex's Tunic", "=q4=#zgt9#=ds=, #r4#" },
        { 19839, "INV_Belt_01", "=q4=Zandalar Haruspex's Belt","=q4=#zgt4#=ds=, #r3#" },
        { 19840, "INV_Bracer_08", "=q4=Zandalar Haruspex's Bracers", "=q4=#zgt5#=ds=, #r2#" },
        };

    ZGHunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#zgs2#", "" },
        { 19953, "INV_Jewelry_Necklace_19", "=q4=Renataki's Charm of Beasts", "" },
        { 19621, "INV_Jewelry_Necklace_26", "=q4=Maelstrom's Wrath", "=ds=#r5#" },
        { 19831, "INV_Shoulder_22", "=q4=Zandalar Predator's Mantle", "=q4=#zgt6#=ds=, #r4#" },
        { 19832, "INV_Belt_19", "=q4=Zandalar Predator's Belt", "=q4=#zgt2#=ds=, #r3#" },
        { 19833, "INV_Bracer_18", "=q4=Zandalar Predator's Bracers", "=q4=#zgt3#=ds=, #r2#" },
        };

    ZGMage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#zgs3#", "" },
        { 19959, "INV_Jewelry_Necklace_19", "=q4=Hazza'rah's Charm of Magic", "" },
        { 19601, "INV_Jewelry_Necklace_26", "=q4=Jewel of Kajaro", "=ds=#r5#" },
        { 20034, "INV_Chest_Cloth_12", "=q4=Zandalar Illusionist's Robe", "=q4=#zgt1#=ds=, #r4#" },
        { 19845, "INV_Shoulder_17", "=q4=Zandalar Illusionist's Mantle", "=q4=#zgt2#=ds=, #r3#" },
        { 19846, "INV_Bracer_07", "=q4=Zandalar Illusionist's Wraps", "=q4=#zgt3#=ds=, #r2#" },
        };

    ZGPaladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#zgs4#", "" },
        { 19952, "INV_Jewelry_Necklace_19", "=q4=Gri'lek's Charm of Valor", "" },
        { 19588, "INV_Jewelry_Necklace_26", "=q4=Hero's Brand", "=ds=#r5#" },
        { 19825, "INV_Chest_Plate07", "=q4=Zandalar Freethinker's Breastplate", "=q4=#zgt9#=ds=, #r4#" },
        { 19826, "INV_Belt_32", "=q4=Zandalar Freethinker's Belt", "=q4=#zgt2#=ds=, #r3#" },
        { 19827, "INV_Bracer_14", "=q4=Zandalar Freethinker's Armguards", "=q4=#zgt3#=ds=, #r2#" },
        };

    ZGPriest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#zgs5#", "" },
        { 19958, "INV_Jewelry_Necklace_19", "=q4=Hazza'rah's Charm of Healing", "" },
        { 19594, "INV_Jewelry_Necklace_26", "=q4=The All-Seeing Eye of Zuldazar", "=ds=#r5#" },
        { 19841, "INV_Shoulder_01", "=q4=Zandalar Confessor's Mantle", "=q4=#zgt6#=ds=, #r4#" },
        { 19842, "INV_Belt_08", "=q4=Zandalar Confessor's Bindings", "=q4=#zgt4#=ds=, #r3#" },
        { 19843, "INV_Bracer_07", "=q4=Zandalar Confessor's Wraps", "=q4=#zgt5#=ds=, #r2#" },
        };

    ZGRogue = {
        { 0, "Ability_BackStab", "=q6=#zgs6#", "" },
        { 19954, "INV_Jewelry_Necklace_19", "=q4=Renataki's Charm of Trickery", "" },
        { 19617, "INV_Jewelry_Necklace_26", "=q4=Zandalarian Shadow Mastery Talisman", "=ds=#r5#" },
        { 19834, "INV_Chest_Leather_10", "=q4=Zandalar Madcap's Tunic", "=q4=#zgt6#=ds=, #r4#" },
        { 19835, "INV_Shoulder_29", "=q4=Zandalar Madcap's Mantle", "=q4=#zgt7#=ds=, #r3#" },
        { 19836, "INV_Bracer_14", "=q4=Zandalar Madcap's Bracers", "=q4=#zgt8#=ds=, #r2#" },
        };

    ZGShaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#zgs7#", "" },
        { 19956, "INV_Jewelry_Necklace_19", "=q4=Wushoolay's Charm of Spirits", "" },
        { 19609, "INV_Jewelry_Necklace_26", "=q4=Unmarred Vision of Voodress", "=ds=#r5#" },
        { 19828, "INV_Chest_Fur", "=q4=Zandalar Augur's Hauberk", "=q4=#zgt9#=ds=, #r4#" },
        { 19829, "INV_Belt_19", "=q4=Zandalar Augur's Belt", "=q4=#zgt7#=ds=, #r3#" },
        { 19830, "INV_Bracer_15", "=q4=Zandalar Augur's Bracers", "=q4=#zgt8#=ds=, #r2#" },
        };

    ZGWarlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#zgs8#", "" },
        { 19957, "INV_Jewelry_Necklace_19", "=q4=Hazza'rah's Charm of Destruction", "" },
        { 19605, "INV_Jewelry_Necklace_26", "=q4=Kezan's Unstoppable Taint", "=ds=#r5#" },
        { 20033, "INV_Chest_Cloth_12", "=q4=Zandalar Demoniac's Robe", "=q4=#zgt1#=ds=, #r4#" },
        { 19849, "INV_Shoulder_17", "=q4=Zandalar Demoniac's Mantle", "=q4=#zgt4#=ds=, #r3#" },
        { 19848, "INV_Bracer_07", "=q4=Zandalar Demoniac's Wraps", "=q4=#zgt5#=ds=, #r2#" },
        };

    ZGWarrior = {
        { 0, "INV_Shield_05", "=q6=#zgs9#", "" },
        { 19951, "INV_Jewelry_Necklace_19", "=q4=Gri'lek's Charm of Might", "" },
        { 19577, "INV_Jewelry_Necklace_26", "=q4=Rage of Mugamba", "=ds=#r5#" },
        { 19822, "INV_Chest_Plate07", "=q4=Zandalar Vindicator's Breastplate", "=q4=#zgt1#=ds=, #r4#" },
        { 19823, "INV_Belt_32", "=q4=Zandalar Vindicator's Belt", "=q4=#zgt7#=ds=, #r3#" },
        { 19824, "INV_Bracer_14", "=q4=Zandalar Vindicator's Armguards", "=q4=#zgt8#=ds=, #r2#" },
        };

-- AQ20 Sets

    AQ20Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#aq20s1#", "" },
        { 21407, "INV_Mace22", "=q4=Mace of Unending Life", "=q4=#aq20t1#=ds=, #r5#" },
        { 21409, "INV_Misc_Cape_15", "=q4=Cloak of Unending Life", "=q3=#aq20t5#=ds=, #r4#" },
        { 21408, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Band of Unending Life", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Hunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#aq20s2#", "" },
        { 21401, "INV_Axe_15", "=q4=Scythe of the Unseen Path", "=q4=#aq20t6#=ds=, #r5#" },
        { 21403, "INV_Misc_Cape_15", "=q4=Cloak of the Unseen Path", "=q3=#aq20t5#=ds=, #r4#" },
        { 21402, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Signet of the Unseen Path", "=q3=#aq20t4#=ds=, #r3#" },
        };
        
    AQ20Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#aq20s3#", "" },
        { 21413, "INV_Sword_57", "=q4=Blade of Vaulted Secrets", "=q4=#aq20t1#=ds=, #r5#" },
        { 21415, "INV_Misc_Cape_19", "=q4=Drape of Vaulted Secrets", "=q3=#aq20t2#=ds=, #r4#" },
        { 21414, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Band of Vaulted Secrets", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Paladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#aq20s4#", "" },
        { 21395, "INV_Sword_57", "=q4=Blade of Eternal Justice", "=q4=#aq20t6#=ds=, #r5#" },
        { 21397, "INV_Misc_Cape_14", "=q4=Cape of Eternal Justice", "=q3=#aq20t5#=ds=, #r4#" },
        { 21396, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Ring of Eternal Justice", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#aq20s5#", "" },
        { 21410, "INV_Mace22", "=q4=Gavel of Infinite Wisdom", "=q4=#aq20t1#=ds=, #r5#" },
        { 21412, "INV_Misc_Cape_16", "=q4=Shroud of Infinite Wisdom", "=q3=#aq20t2#=ds=, #r4#" },
        { 21411, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Ring of Infinite Wisdom", "=q3=#aq20t4#=ds=, #r3#" },
        };

    AQ20Rogue = {
        { 0, "Ability_BackStab", "=q6=#aq20s6#", "" },
        { 21404, "INV_Weapon_ShortBlade_27", "=q4=Dagger of Veiled Shadows", "=q4=#aq20t6#=ds=, #r5#" },
        { 21406, "INV_Misc_Cape_19", "=q4=Cloak of Veiled Shadows", "=q3=#aq20t2#=ds=, #r4#" },
        { 21405, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Band of Veiled Shadows", "=q3=#aq20t4#=ds=, #r3#" },
        };

    AQ20Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#aq20s7#", "" },
        { 21398, "INV_Mace22", "=q4=Hammer of the Gathering Storm", "=q4=#aq20t6#=ds=, #r5#" },
        { 21400, "INV_Misc_Cape_16", "=q4=Cloak of the Gathering Storm", "=q3=#aq20t5#=ds=, #r4#" },
        { 21399, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Ring of the Gathering Storm", "=q3=#aq20t3#=ds=, #r3#" },
        };

    AQ20Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#aq20s8#", "" },
        { 21416, "INV_Weapon_ShortBlade_27", "=q4=Kris of Unspoken Names", "=q4=#aq20t1#=ds=, #r5#" },
        { 21418, "INV_Misc_Cape_20", "=q4=Shroud of Unspoken Names", "=q3=#aq20t5#=ds=, #r4#" },
        { 21417, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Ring of Unspoken Names", "=q3=#aq20t4#=ds=, #r3#" },
        };

    AQ20Warrior = {
        { 0, "INV_Shield_05", "=q6=#aq20s9#", "" },
        { 21392, "INV_Axe_15", "=q4=Sickle of Unyielding Strength", "=q4=#aq20t6#=ds=, #r5#" },
        { 21394, "INV_Misc_Cape_20", "=q4=Drape of Unyielding Strength", "=q3=#aq20t2#=ds=, #r4#" },
        { 21393, "INV_Jewelry_Ring_AhnQiraj_03", "=q4=Signet of Unyielding Strength", "=q3=#aq20t3#=ds=, #r3#" },
        };

-- AQ40 Sets

    AQ40Druid = {
        { 0, "Spell_Nature_Regeneration", "=q6=#aq40s1#", "" },
        { 21357, "INV_Chest_Leather_08", "=q4=Genesis Vest", "=q4=#aq40t4#=ds=, #r3#" },
        { 21353, "INV_Helmet_06", "=q4=Genesis Helm", "=q4=#aq40t6#=ds=, #r2#" },
        { 21356, "INV_Pants_Leather_01", "=q4=Genesis Trousers", "=q4=#aq40t7#=ds=, #r2#" },
        { 21354, "INV_Shoulder_03", "=q4=Genesis Shoulderpads", "=q4=#aq40t1#=ds=, #r1#" },
        { 21355, "INV_Boots_Cloth_07", "=q4=Genesis Boots", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Hunter = {
        { 0, "Ability_Hunter_RunningShot", "=q6=#aq40s2#", "" },
        { 21370, "INV_Chest_Chain_04", "=q4=Striker's Hauberk", "=q4=#aq40t8#=ds=, #r3#" },
        { 21366, "INV_Helmet_73", "=q4=Striker's Diadem", "=q4=#aq40t6#=ds=, #r2#" },
        { 21368, "INV_Pants_Mail_11", "=q4=Striker's Leggings", "=q4=#aq40t7#=ds=, #r2#" },
        { 21367, "INV_Shoulder_36", "=q4=Striker's Pauldrons", "=q4=#aq40t5#=ds=, #r1#" },
        { 21365, "INV_Boots_Chain_08", "=q4=Striker's Footguards", "=q4=#aq40t5#=ds=, #r1#" },
        };
        
    AQ40Mage = {
        { 0, "Spell_Frost_IceStorm", "=q6=#aq40s3#", "" },
        { 21343, "INV_Chest_Cloth_11", "=q4=Enigma Robes", "=q4=#aq40t4#=ds=, #r3#" },
        { 21347, "INV_Helmet_06", "=q4=Enigma Circlet", "=q4=#aq40t2#=ds=, #r2#" },
        { 21346, "INV_Pants_Cloth_08", "=q4=Enigma Leggings", "=q4=#aq40t3#=ds=, #r2#" },
        { 21345, "INV_Shoulder_03", "=q4=Enigma Shoulderpads", "=q4=#aq40t1#=ds=, #r1#" },
        { 21344, "INV_Boots_Cloth_03", "=q4=Enigma Boots", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Paladin = {
        { 0, "Spell_Holy_SealOfMight", "=q6=#aq40s4#", "" },
        { 21389, "INV_Chest_Plate03", "=q4=Avenger's Breastplate", "=q4=#aq40t8#=ds=, #r3#" },
        { 21387, "INV_Helmet_72", "=q4=Avenger's Crown", "=q4=#aq40t6#=ds=, #r2#" },
        { 21390, "INV_Pants_Plate_02", "=q4=Avenger's Legguards", "=q4=#aq40t7#=ds=, #r2#" },
        { 21391, "INV_Shoulder_35", "=q4=Avenger's Pauldrons", "=q4=#aq40t1#=ds=, #r1#" },
        { 21388, "INV_Boots_Chain_07", "=q4=Avenger's Greaves", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Priest = {
        { 0, "Spell_Holy_PowerWordShield", "=q6=#aq40s5#", "" },
        { 21351, "INV_Chest_Cloth_10", "=q4=Vestments of the Oracle", "=q4=#aq40t4#=ds=, #r3#" },
        { 21348, "INV_Helmet_06", "=q4=Tiara of the Oracle", "=q4=#aq40t2#=ds=, #r2#" },
        { 21352, "INV_Pants_Cloth_07", "=q4=Trousers of the Oracle","=q4=#aq40t3#=ds=, #r2#" },
        { 21350, "INV_Shoulder_03", "=q4=Mantle of the Oracle", "=q4=#aq40t5#=ds=, #r1#" },
        { 21349, "INV_Boots_Cloth_07", "=q4=Footwraps of the Oracle", "=q4=#aq40t5#=ds=, #r1#" },
        };

    AQ40Rogue = {
        { 0, "Ability_BackStab", "=q6=#aq40s6#", "" },
        { 21364, "INV_Chest_Leather_08", "=q4=Deathdealer's Vest", "=q4=#aq40t8#=ds=, #r3#" },
        { 21360, "INV_Helmet_04", "=q4=Deathdealer's Helm", "=q4=#aq40t6#=ds=, #r2#" },
        { 21362, "INV_Pants_Leather_07", "=q4=Deathdealer's Leggings", "=q4=#aq40t3#=ds=, #r2#" },
        { 21361, "INV_Shoulder_03", "=q4=Deathdealer's Spaulders", "=q4=#aq40t5#=ds=, #r1#" },
        { 21359, "INV_Boots_08", "=q4=Deathdealer's Boots", "=q4=#aq40t5#=ds=, #r1#" },
        };

    AQ40Shaman = {
        { 0, "Spell_FireResistanceTotem_01", "=q6=#aq40s7#", "" },
        { 21374, "INV_Chest_Chain_13", "=q4=Stormcaller's Hauberk", "=q4=#aq40t8#=ds=, #r3#" },
        { 21372, "INV_Helmet_73", "=q4=Stormcaller's Diadem", "=q4=#aq40t6#=ds=, #r2#" },
        { 21375, "INV_Pants_Mail_10", "=q4=Stormcaller's Leggings", "=q4=#aq40t7#=ds=, #r2#" },
        { 21376, "INV_Shoulder_03", "=q4=Stormcaller's Pauldrons", "=q4=#aq40t1#=ds=, #r1#" },
        { 21373, "INV_Boots_Chain_07", "=q4=Stormcaller's Footguards", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Warlock = {
        { 0, "Spell_Shadow_CurseOfTounges", "=q6=#aq40s8#", "" },
        { 21334, "INV_Chest_Cloth_12", "=q4=Doomcaller's Robes", "=q4=#aq40t4#=ds=, #r3#" },
        { 21337, "INV_Helmet_06", "=q4=Doomcaller's Circlet", "=q4=#aq40t2#=ds=, #r2#" },
        { 21336, "INV_Pants_Cloth_02", "=q4=Doomcaller's Trousers", "=q4=#aq40t7#=ds=, #r2#" },
        { 21335, "INV_Shoulder_03", "=q4=Doomcaller's Mantle", "=q4=#aq40t1#=ds=, #r1#" },
        { 21338, "INV_Boots_Cloth_02", "=q4=Doomcaller's Footwraps", "=q4=#aq40t1#=ds=, #r1#" },
        };

    AQ40Warrior = {
        { 0, "INV_Shield_05", "=q6=#aq40s9#", "" },
        { 21331, "INV_Chest_Plate12", "=q4=Conqueror's Breastplate", "=q4=#aq40t8#=ds=, #r3#" },
        { 21329, "INV_Helmet_72", "=q4=Conqueror's Crown", "=q4=#aq40t2#=ds=, #r2#" },
        { 21332, "INV_Pants_Plate_03", "=q4=Conqueror's Legguards", "=q4=#aq40t3#=ds=, #r2#" },
        { 21330, "INV_Shoulder_35", "=q4=Conqueror's Spaulders", "=q4=#aq40t5#=ds=, #r1#" },
        { 21333, "INV_Boots_Plate_05", "=q4=Conqueror's Greaves", "=q4=#aq40t5#=ds=, #r1#" },
        };

-- PvP Level 60 Rare and Epic Sets

    PVPDruid = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea1#", "=q5=#pvps1#" },
        { 16451, "INV_Helmet_41", "=q4=Field Marshal's Dragonhide Helmet", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16449, "INV_Shoulder_23", "=q4=Field Marshal's Dragonhide Spaulders", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16452, "INV_Chest_Cloth_07", "=q4=Field Marshal's Dragonhide Breastplate", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16448, "INV_Gauntlets_21", "=q4=Marshal's Dragonhide Gauntlets", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 16450, "INV_Pants_06", "=q4=Marshal's Dragonhide Legguards", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16459, "INV_Boots_08", "=q4=Marshal's Dragonhide Boots", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra1#", "=q5=#pvps2#" },
        { 23308, "INV_Helmet_09", "=q3=Lieutenant Commander's Dragonhide Headguard", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23309, "INV_Shoulder_07", "=q3=Lieutenant Commander's Dragonhide Shoulders", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23294, "INV_Chest_Leather_07", "=q3=Knight-Captain's Dragonhide Chestpiece", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23280, "INV_Gauntlets_25", "=q3=Knight-Lieutenant's Dragonhide Grips", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23295, "INV_Pants_06", "=q3=Knight-Captain's Dragonhide Leggings", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23281, "INV_Boots_08", "=q3=Knight-Lieutenant's Dragonhide Treads", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh1#", "=q5=#pvps1#" },
        { 16550, "INV_Helmet_09", "=q4=Warlord's Dragonhide Helmet", "", "", "13005", "#horde#", "30", "#av#" },
        { 16551, "INV_Shoulder_07", "=q4=Warlord's Dragonhide Epaulets", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16549, "INV_Chest_Chain_16", "=q4=Warlord's Dragonhide Hauberk", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16555, "INV_Gauntlets_25", "=q4=General's Dragonhide Gloves", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16552, "INV_Pants_06", "=q4=General's Dragonhide Leggings", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16554, "INV_Boots_08", "=q4=General's Dragonhide Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh1#", "=q5=#pvps2#" },
        { 23253, "INV_Helmet_09", "=q3=Champion's Dragonhide Headguard", "", "", "4335", "#horde#", "30", "#av#" },
        { 23254, "INV_Shoulder_07", "=q3=Champion's Dragonhide Shoulders", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22877, "INV_Chest_Leather_07", "=q3=Legionnaire's Dragonhide Chestpiece", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22863, "INV_Gauntlets_25", "=q3=Blood Guard's Dragonhide Grips", "", "", "2805", "#horde#", "20", "#av#" },
        { 22878, "INV_Pants_06", "=q3=Legionnaire's Dragonhide Leggings", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22852, "INV_Boots_08", "=q3=Blood Guard's Dragonhide Treads", "", "", "2805", "#horde#", "20", "#ab#" },
        };
        
    PVPHunter = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea2#", "=q5=#pvps1#" },
        { 16465, "INV_Helmet_05", "=q4=Field Marshal's Chain Helm", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16468, "INV_Shoulder_10", "=q4=Field Marshal's Chain Spaulders", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16466, "INV_Chest_Chain_03", "=q4=Field Marshal's Chain Breastplate", "", "", "13770", "#alliance#", "30", "#ab#" },
        { 16463, "INV_Gauntlets_10", "=q4=Marshal's Chain Grips", "", "", "8415", "#alliance#", "20", "#av#" },
        { 16467, "INV_Pants_Mail_17", "=q4=Marshal's Chain Legguards", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16462, "INV_Boots_Plate_07", "=q4=Marshal's Chain Boots", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra2#", "=q5=#pvps2#" },
        { 23306, "INV_Helmet_21", "=q3=Lieutenant Commander's Chain Helm", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23307, "INV_Shoulder_16", "=q3=Lieutenant Commander's Chain Shoulders", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23292, "INV_Chest_Chain_04", "=q3=Knight-Captain's Chain Hauberk", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23279, "INV_Gauntlets_17", "=q3=Knight-Lieutenant's Chain Vices", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23293, "INV_Pants_03", "=q3=Knight-Captain's Chain Legguards", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23278, "INV_Boots_05", "=q3=Knight-Lieutenant's Chain Greaves", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh2#", "=q5=#pvps1#" },
        { 16566, "INV_Helmet_09", "=q4=Warlord's Chain Helmet", "", "", "13005", "#horde#", "30", "#av#" },
        { 16568, "INV_Shoulder_29", "=q4=Warlord's Chain Shoulders", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16565, "INV_Chest_Chain_11", "=q4=Warlord's Chain Chestpiece", "", "", "13770", "#horde#", "30", "#ab#" },
        { 16571, "INV_Gauntlets_11", "=q4=General's Chain Gloves", "", "", "8415", "#horde#", "20", "#av#" },
        { 16567, "INV_Pants_Mail_16", "=q4=General's Chain Legguards", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16569, "INV_Boots_Plate_06", "=q4=General's Chain Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh2#", "=q5=#pvps2#" },
        { 23251, "INV_Helmet_03", "=q3=Champion's Chain Helm", "", "", "4335", "#horde#", "30", "#av#" },
        { 23252, "INV_Shoulder_01", "=q3=Champion's Chain Shoulders", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22874, "INV_Chest_Chain_04", "=q3=Legionnaire's Chain Hauberk", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22862, "INV_Gauntlets_17", "=q3=Blood Guard's Chain Vices", "", "", "2805", "#horde#", "20", "#av#" },
        { 22875, "INV_Pants_03", "=q3=Legionnaire's Chain Legguards", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22843, "INV_Boots_05", "=q3=Blood Guard's Chain Greaves", "", "", "2805", "#horde#", "20", "#ab#" },
        };
    
    PVPMage = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea3#", "=q5=#pvps1#" },
        { 16441, "INV_Helmet_24", "=q4=Field Marshal's Coronet", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16444, "INV_Shoulder_23", "=q4=Field Marshal's Silk Spaulders", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16443, "INV_Chest_Cloth_12", "=q4=Field Marshal's Silk Vestments", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16440, "INV_Gauntlets_14", "=q4=Marshal's Silk Gloves", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 16442, "INV_Pants_08", "=q4=Marshal's Silk Leggings", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16437, "INV_Boots_Cloth_03", "=q4=Marshal's Silk Footwraps", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra3#", "=q5=#pvps2#" },
        { 23318, "INV_Helmet_06", "=q3=Lieutenant Commander's Silk Cowl", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23319, "INV_Shoulder_02", "=q3=Lieutenant Commander's Silk Mantle", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23305, "INV_Chest_Cloth_28", "=q3=Knight-Captain's Silk Tunic", "", "", "4590", "#alliance#", "30", "#ab#" },
	{ 23290, "INV_Gauntlets_06", "=q3=Knight-Lieutenant's Silk Handwraps", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23304, "INV_Pants_11", "=q3=Knight-Captain's Silk Legguards", "", "", "4335", "#alliance#", "30", "#wsg#" },
	{ 23291, "INV_Boots_05", "=q3=Knight-Lieutenant's Silk Walkers", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh3#", "=q5=#pvps1#" },
        { 16533, "INV_Helmet_08", "=q4=Warlord's Silk Cowl", "", "", "13005", "#horde#", "30", "#av#" },
        { 16536, "INV_Shoulder_19", "=q4=Warlord's Silk Amice", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16535, "INV_Chest_Leather_01", "=q4=Warlord's Silk Raiment", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16540, "INV_Gauntlets_19", "=q4=General's Silk Handguards", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16534, "INV_Pants_07", "=q4=General's Silk Trousers", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16539, "INV_Boots_05", "=q4=General's Silk Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh3#", "=q5=#pvps2#" },
        { 23263, "INV_Helmet_06", "=q3=Champion's Silk Cowl", "", "", "4335", "#horde#", "30", "#av#" },
        { 23264, "INV_Shoulder_02", "=q3=Champion's Silk Mantle", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22886, "INV_Chest_Cloth_28", "=q3=Legionnaire's Silk Tunic", "", "", "4590", "#horde#", "30", "#ab#" },
	{ 22870, "INV_Gauntlets_06", "=q3=Blood Guard's Silk Handwraps", "", "", "2805", "#horde#", "20", "#av#" },
        { 22883, "INV_Pants_11", "=q3=Legionnaire's Silk Legguards", "", "", "4335", "#horde#", "30", "#wsg#" },
	{ 22860, "INV_Boots_05", "=q3=Blood Guard's Silk Walkers", "", "", "2805", "#horde#", "20", "#ab#" },
	};

    PVPPaladin = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea4#", "=q5=#pvps1#" },
        { 16474, "INV_Helmet_05", "=q4=Field Marshal's Lamellar Faceguard", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16476, "INV_Shoulder_20", "=q4=Field Marshal's Lamellar Pauldrons", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16473, "INV_Chest_Plate03", "=q4=Field Marshal's Lamellar Chestplate", "", "", "13770", "#alliance#", "30", "#ab#" },
        { 16471, "INV_Gauntlets_29", "=q4=Marshal's Lamellar Gloves", "", "", "8415", "#alliance#", "20", "#av#" },
        { 16475, "INV_Pants_04", "=q4=Marshal's Lamellar Legplates", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16472, "INV_Boots_Plate_09", "=q4=Marshal's Lamellar Boots", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra4#", "=q5=#pvps2#" },
        { 23276, "INV_Helmet_05", "=q3=Lieutenant Commander's Lamellar Headguard", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23277, "INV_Shoulder_28", "=q3=Lieutenant Commander's Lamellar Shoulders", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23272, "INV_Chest_Plate03", "=q3=Knight-Captain's Lamellar Breastplate", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23274, "INV_Gauntlets_29", "=q3=Knight-Lieutenant's Lamellar Gauntlets", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23273, "INV_Pants_06", "=q3=Knight-Captain's Lamellar Leggings", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23275, "INV_Boots_Plate_03", "=q3=Knight-Lieutenant's Lamellar Sabatons", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh9#", "=q5=#pvps1#" },
        { 29616, "INV_Helmet_05", "=q4=Warlord's Lamellar Faceguard", "", "", "13005", "#horde#", "30", "#av#" },
        { 29617, "INV_Shoulder_20", "=q4=Warlord's Lamellar Pauldrons", "", "", "8415", "#horde#", "20", "#ab#" },
        { 29615, "INV_Chest_Plate03", "=q4=Warlord's Lamellar Chestplate", "", "", "13770", "#horde#", "30", "#ab#" },
        { 29613, "INV_Gauntlets_29", "=q4=General's Lamellar Gloves", "", "", "8415", "#horde#", "20", "#av#" },
        { 29614, "INV_Pants_04", "=q4=General's Lamellar Legplates", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 29612, "INV_Boots_Plate_09", "=q4=General's Lamellar Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh9#", "=q5=#pvps2#" },
        { 29604, "INV_Helmet_05", "=q3=Champion's Lamellar Headguard", "", "", "4335", "#horde#", "30", "#av#" },
	{ 29605, "INV_Shoulder_28", "=q3=Champion's Lamellar Shoulders", "", "", "2805", "#horde#", "20", "#ab#" },
	{ 29602, "INV_Chest_Plate03", "=q3=Legionnaire's Lamellar Breastplate", "", "", "4590", "#horde#", "30", "#ab#" },
        { 29600, "INV_Gauntlets_29", "=q3=Blood Guard's Lamellar Gauntlets", "", "", "2805", "#horde#", "20", "#av#" },
	{ 29603, "INV_Pants_06", "=q3=Legionnaire's Lamellar Leggings", "", "", "4335", "#horde#", "30", "#wsg#" },
	{ 29601, "INV_Boots_Plate_03", "=q3=Blood Guard's Lamellar Sabatons", "", "", "2805", "#horde#", "20", "#ab#" },
	};
        
    PVPPriest = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea5#", "=q5=#pvps1#" },
        { 17602, "INV_Helmet_24", "=q4=Field Marshal's Headdress", "", "", "13005", "#alliance#", "30", "#av#" },
	{ 17604, "INV_Shoulder_02", "=q4=Field Marshal's Satin Mantle", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 17605, "INV_Chest_Cloth_02", "=q4=Field Marshal's Satin Vestments", "", "", "13770", "#alliance#", "30", "#ab#" },
        { 17608, "INV_Gauntlets_14", "=q4=Marshal's Satin Gloves", "", "", "8415", "#alliance#", "20", "#av#" },
        { 17603, "INV_Pants_06", "=q4=Marshal's Satin Pants", "", "", "13005", "#alliance#", "30", "#wsg#" },
	{ 17607, "INV_Boots_07", "=q4=Marshal's Satin Sandals", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra5#", "=q5=#pvps2#" },
	{ 23316, "INV_Helmet_17", "=q3=Lieutenant Commander's Satin Hood", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23317, "INV_Shoulder_01", "=q3=Lieutenant Commander's Satin Mantle", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23303, "INV_Chest_Leather_01", "=q3=Knight-Captain's Satin Tunic", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23288, "INV_Gauntlets_17", "=q3=Knight-Lieutenant's Satin Handwraps", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23302, "INV_Pants_11", "=q3=Knight-Captain's Satin Legguards", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23289, "INV_Boots_05", "=q3=Knight-Lieutenant's Satin Walkers", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh4#", "=q5=#pvps1#" },
        { 17623, "INV_Helmet_08", "=q4=Warlord's Satin Cowl", "", "", "13005", "#horde#", "30", "#av#" },
	{ 17622, "INV_Shoulder_19", "=q4=Warlord's Satin Mantle", "", "", "8415", "#horde#", "20", "#ab#" },
        { 17624, "INV_Chest_Leather_01", "=q4=Warlord's Satin Robes", "", "", "13770", "#horde#", "30", "#ab#" },
        { 17620, "INV_Gauntlets_27", "=q4=General's Satin Gloves", "", "", "8415", "#horde#", "20", "#av#" },
        { 17625, "INV_Pants_07", "=q4=General's Satin Leggings", "", "", "13005", "#horde#", "30", "#wsg#" },
	{ 17618, "INV_Boots_05", "=q4=General's Satin Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh4#", "=q5=#pvps2#" },
	{ 23261, "INV_Helmet_17", "=q3=Champion's Satin Hood", "", "", "4335", "#horde#", "30", "#av#" },
        { 23262, "INV_Shoulder_01", "=q3=Champion's Satin Mantle", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22885, "INV_Chest_Leather_01", "=q3=Legionnaire's Satin Tunic", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22869, "INV_Gauntlets_17", "=q3=Blood Guard's Satin Handwraps", "", "", "2805", "#horde#", "20", "#av#" },
        { 22882, "INV_Pants_11", "=q3=Legionnaire's Satin Legguards", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22859, "INV_Boots_05", "=q3=Blood Guard's Satin Walkers", "", "", "2805", "#horde#", "20", "#ab#" },
        };

    PVPRogue = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea6#", "=q5=#pvps1#" },
        { 16455, "INV_Helmet_41", "=q4=Field Marshal's Leather Mask", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16457, "INV_Shoulder_23", "=q4=Field Marshal's Leather Epaulets", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16453, "INV_Chest_Cloth_07", "=q4=Field Marshal's Leather Chestpiece", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16454, "INV_Gauntlets_21", "=q4=Marshal's Leather Handgrips", "", "", "8415", "#alliance#", "20", "#av#" },
        { 16456, "INV_Pants_06", "=q4=Marshal's Leather Leggings", "", "", "13005", "#alliance#", "30", "#wsg#" },
	{ 16446, "INV_Boots_08", "=q4=Marshal's Leather Footguards", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra6#", "=q5=#pvps2#" },
        { 23312, "INV_Helmet_09", "=q3=Lieutenant Commander's Leather Helm", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23313, "INV_Shoulder_14", "=q3=Lieutenant Commander's Leather Shoulders", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23298, "INV_Chest_Leather_05", "=q3=Knight-Captain's Leather Chestpiece", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23284, "INV_Gauntlets_15", "=q3=Knight-Lieutenant's Leather Grips", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23299, "INV_Pants_08", "=q3=Knight-Captain's Leather Legguards", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23285, "INV_Boots_05", "=q3=Knight-Lieutenant's Leather Walkers", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh5#", "=q5=#pvps1#" },
        { 16561, "INV_Helmet_09", "=q4=Warlord's Leather Helm", "", "", "13005", "#horde#", "30", "#av#" },
        { 16562, "INV_Shoulder_07", "=q4=Warlord's Leather Spaulders", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16563, "INV_Chest_Chain_16", "=q4=Warlord's Leather Breastplate", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16560, "INV_Gauntlets_25", "=q4=General's Leather Mitts", "", "", "8415", "#horde#", "20", "#av#" },
        { 16564, "INV_Pants_06", "=q4=General's Leather Legguards", "", "", "13005", "#horde#", "30", "#wsg#" },
	{ 16558, "INV_Boots_08", "=q4=General's Leather Treads", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh5#", "=q5=#pvps2#" },
        { 23257, "INV_Helmet_09", "=q3=Champion's Leather Helm", "", "", "4335", "#horde#", "30", "#av#" },
        { 23258, "INV_Shoulder_14", "=q3=Champion's Leather Shoulders", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22879, "INV_Chest_Leather_05", "=q3=Legionnaire's Leather Chestpiece", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22864, "INV_Gauntlets_15", "=q3=Blood Guard's Leather Grips", "", "", "2805", "#horde#", "20", "#av#" },
        { 22880, "INV_Pants_08", "=q3=Legionnaire's Leather Legguards", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22856, "INV_Boots_05", "=q3=Blood Guard's Leather Walkers", "", "", "2805", "#horde#", "20", "#ab#" },
	};

    PVPShaman = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea9#", "=q5=#pvps1#" },
        { 29610, "INV_Helmet_09", "=q4=Field Marshal's Mail Helm", "", "", "13005", "#alliance#", "30", "#av#" },
        { 29611, "INV_Shoulder_29", "=q4=Field Marshal's Mail Spaulders", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 29609, "INV_Chest_Chain_11", "=q4=Field Marshal's Mail Armor", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 29607, "INV_Gauntlets_11", "=q4=Marshal's Mail Gauntlets", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 29608, "INV_Pants_Mail_15", "=q4=Marshal's Mail Leggings", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 29606, "INV_Boots_Plate_06", "=q4=Marshal's Mail Boots", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra9#", "=q5=#pvps2#" },
        { 29598, "INV_Helmet_09", "=q3=Lieutenant Commander's Mail Headguard", "", "", "4335", "#alliance#", "30", "#av#" },
        { 29599, "INV_Shoulder_04", "=q3=Lieutenant Commander's Mail Pauldrons", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 29596, "INV_Chest_Chain_16", "=q3=Knight-Captain's Mail Hauberk", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 29595, "INV_Gauntlets_11", "=q3=Knight-Lieutenant's Mail Vices", "", "", "2805", "#alliance#", "20", "#av#" },
        { 29597, "INV_Pants_09", "=q3=Knight-Captain's Mail Legguards", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 29594,"INV_Boots_07","=q3=Knight-Lieutenant's Mail Greaves","", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh6#", "=q5=#pvps1#" },
        { 16578, "INV_Helmet_09", "=q4=Warlord's Mail Helm", "", "", "13005", "#horde#", "30", "#av#" },
        { 16580, "INV_Shoulder_29", "=q4=Warlord's Mail Spaulders", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16577, "INV_Chest_Chain_11", "=q4=Warlord's Mail Armor", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16574, "INV_Gauntlets_11", "=q4=General's Mail Gauntlets", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16579, "INV_Pants_Mail_15", "=q4=General's Mail Leggings", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16573, "INV_Boots_Plate_06", "=q4=General's Mail Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh6#", "=q5=#pvps2#" },
        { 23259, "INV_Helmet_09", "=q3=Champion's Mail Headguard", "", "", "4335", "#horde#", "30", "#av#" },
        { 23260, "INV_Shoulder_04", "=q3=Champion's Mail Pauldrons", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22876, "INV_Chest_Chain_16", "=q3=Legionnaire's Mail Hauberk", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22867, "INV_Gauntlets_11", "=q3=Blood Guard's Mail Vices", "", "", "2805", "#horde#", "20", "#av#" },
        { 22887, "INV_Pants_09", "=q3=Legionnaire's Mail Legguards", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22857,"INV_Boots_07","=q3=Blood Guard's Mail Greaves","", "", "2805", "#horde#", "20", "#ab#" },
        };

    PVPWarlock = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea7#", "=q5=#pvps1#" },
        { 17578, "INV_Helmet_24", "=q4=Field Marshal's Coronal", "", "", "13005", "#alliance#", "30", "#av#" },
        { 17580, "INV_Shoulder_02", "=q4=Field Marshal's Dreadweave Shoulders", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 17581, "INV_Chest_Cloth_09", "=q4=Field Marshal's Dreadweave Robe", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 17584, "INV_Gauntlets_14", "=q4=Marshal's Dreadweave Gloves", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 17579, "INV_Pants_Cloth_09", "=q4=Marshal's Dreadweave Leggings", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 17583, "INV_Boots_07", "=q4=Marshal's Dreadweave Boots", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_02", "=q6=#pvpra7#", "=q5=#pvps2#" },
        { 23310, "INV_Helmet_08", "=q3=Lieutenant Commander's Dreadweave Cowl", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23311, "INV_Shoulder_01", "=q3=Lieutenant Commander's Dreadweave Spaulders", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23297, "INV_Chest_Leather_01", "=q3=Knight-Captain's Dreadweave Tunic", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23282, "INV_Gauntlets_19", "=q3=Knight-Lieutenant's Dreadweave Handwraps", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23296, "INV_Pants_06", "=q3=Knight-Captain's Dreadweave Legguards", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23283, "INV_Boots_05", "=q3=Knight-Lieutenant's Dreadweave Walkers", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh7#", "=q5=#pvps1#" },
        { 17591, "INV_Helmet_08", "=q4=Warlord's Dreadweave Hood", "", "", "13005", "#horde#", "30", "#av#" },
        { 17590, "INV_Shoulder_19", "=q4=Warlord's Dreadweave Mantle", "", "", "8415", "#horde#", "20", "#ab#" },
        { 17592, "INV_Chest_Leather_01", "=q4=Warlord's Dreadweave Robe", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 17588, "INV_Gauntlets_19", "=q4=General's Dreadweave Gloves", "", "", "8415", "#horde#", "20", "#av#" },
	{ 17593, "INV_Pants_07", "=q4=General's Dreadweave Pants", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 17586, "INV_Boots_05", "=q4=General's Dreadweave Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
	{ 0, "INV_BannerPVP_01", "=q6=#pvprh7#", "=q5=#pvps2#" },
        { 23255, "INV_Helmet_08", "=q3=Champion's Dreadweave Cowl", "", "", "4335", "#horde#", "30", "#av#" },
        { 23256, "INV_Shoulder_01", "=q3=Champion's Dreadweave Spaulders", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22884, "INV_Chest_Leather_01", "=q3=Legionnaire's Dreadweave Tunic", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22865, "INV_Gauntlets_19", "=q3=Blood Guard's Dreadweave Handwraps", "", "", "2805", "#horde#", "20", "#av#" },
        { 22881, "INV_Pants_06", "=q3=Legionnaire's Dreadweave Legguards", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22855, "INV_Boots_05", "=q3=Blood Guard's Dreadweave Walkers", "", "", "2805", "#horde#", "20", "#ab#" },
        };
        
    PVPWarrior = {
        { 0, "INV_BannerPVP_02", "=q6=#pvpea8#", "=q5=#pvps1#" },
        { 16478, "INV_Helmet_05", "=q4=Field Marshal's Plate Helm", "", "", "13005", "#alliance#", "30", "#av#" },
        { 16480, "INV_Shoulder_20", "=q4=Field Marshal's Plate Shoulderguards", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 16477, "INV_Chest_Plate03", "=q4=Field Marshal's Plate Armor", "", "", "13770", "#alliance#", "30", "#ab#" },
	{ 16484, "INV_Gauntlets_29", "=q4=Marshal's Plate Gauntlets", "", "", "8415", "#alliance#", "20", "#av#" },
	{ 16479, "INV_Pants_04", "=q4=Marshal's Plate Legguards", "", "", "13005", "#alliance#", "30", "#wsg#" },
        { 16483, "INV_Boots_Plate_09", "=q4=Marshal's Plate Boots", "", "", "8415", "#alliance#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvpra8#", "=q5=#pvps2#" },
        { 23314, "INV_Helmet_09", "=q3=Lieutenant Commander's Plate Helm", "", "", "4335", "#alliance#", "30", "#av#" },
        { 23315, "INV_Shoulder_11", "=q3=Lieutenant Commander's Plate Shoulders", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 23300, "INV_Chest_Plate16", "=q3=Knight-Captain's Plate Hauberk", "", "", "4590", "#alliance#", "30", "#ab#" },
        { 23286, "INV_Gauntlets_26", "=q3=Knight-Lieutenant's Plate Gauntlets", "", "", "2805", "#alliance#", "20", "#av#" },
        { 23301, "INV_Pants_06", "=q3=Knight-Captain's Plate Leggings", "", "", "4335", "#alliance#", "30", "#wsg#" },
        { 23287, "INV_Boots_Plate_09", "=q3=Knight-Lieutenant's Plate Greaves", "", "", "2805", "#alliance#", "20", "#ab#" },
        { 0, "INV_BannerPVP_01", "=q6=#pvpeh8#", "=q5=#pvps1#" },
        { 16542, "INV_Helmet_09", "=q4=Warlord's Plate Headpiece", "", "", "13005", "#horde#", "30", "#av#" },
        { 16544, "INV_Shoulder_11", "=q4=Warlord's Plate Shoulders", "", "", "8415", "#horde#", "20", "#ab#" },
        { 16541, "INV_Chest_Plate16", "=q4=Warlord's Plate Armor", "", "", "13770", "#horde#", "30", "#ab#" },
	{ 16548, "INV_Gauntlets_10", "=q4=General's Plate Gauntlets", "", "", "8415", "#horde#", "20", "#av#" },
	{ 16543, "INV_Pants_04", "=q4=General's Plate Leggings", "", "", "13005", "#horde#", "30", "#wsg#" },
        { 16545, "INV_Boots_Plate_04", "=q4=General's Plate Boots", "", "", "8415", "#horde#", "20", "#ab#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvprh8#", "=q5=#pvps2#" },
        { 23244, "INV_Helmet_09", "=q3=Champion's Plate Helm", "", "", "4335", "#horde#", "30", "#av#" },
        { 23243, "INV_Shoulder_11", "=q3=Champion's Plate Shoulders", "", "", "2805", "#horde#", "20", "#ab#" },
        { 22872, "INV_Chest_Plate16", "=q3=Legionnaire's Plate Hauberk", "", "", "4590", "#horde#", "30", "#ab#" },
        { 22868, "INV_Gauntlets_26", "=q3=Blood Guard's Plate Gauntlets", "", "", "2805", "#horde#", "20", "#av#" },
        { 22873, "INV_Pants_06", "=q3=Legionnaire's Plate Leggings", "", "", "4335", "#horde#", "30", "#wsg#" },
        { 22858, "INV_Boots_Plate_09", "=q3=Blood Guard's Plate Greaves", "", "", "2805", "#horde#", "20", "#ab#" },
	  };

-- PvP Level 70 Rare Sets

    PVP70Druid1 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp701_1_a#", "" },
        { 28619, "INV_Helmet_30", "=q3=Grand Marshal's Dragonhide Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28622, "INV_Shoulder_12", "=q3=Grand Marshal's Dragonhide Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28623, "INV_Chest_Leather_03", "=q3=Grand Marshal's Dragonhide Tunic", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28618, "INV_Gauntlets_28", "=q3=Grand Marshal's Dragonhide Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28620, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Dragonhide Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp701_2_a#", "" },
        { 28720, "INV_Helmet_30", "=q3=Grand Marshal's Wyrmhide Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28722, "INV_Shoulder_12", "=q3=Grand Marshal's Wyrmhide Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28723, "INV_Chest_Leather_03", "=q3=Grand Marshal's Wyrmhide Tunic", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28719, "INV_Gauntlets_28", "=q3=Grand Marshal's Wyrmhide Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28721, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Wyrmhide Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp701_1_h#", "" },
        { 28812, "INV_Helmet_30", "=q3=High Warlord's Dragonhide Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28814, "INV_Shoulder_12", "=q3=High Warlord's Dragonhide Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28815, "INV_Chest_Leather_03", "=q3=High Warlord's Dragonhide Tunic", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28811, "INV_Gauntlets_28", "=q3=High Warlord's Dragonhide Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 28813, "INV_Pants_Cloth_05", "=q3=High Warlord's Dragonhide Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp701_2_h#", "" },
        { 28872, "INV_Helmet_30", "=q3=High Warlord's Wyrmhide Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28874, "INV_Shoulder_12", "=q3=High Warlord's Wyrmhide Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28875, "INV_Chest_Leather_03", "=q3=High Warlord's Wyrmhide Tunic", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28871, "INV_Gauntlets_28", "=q3=High Warlord's Wyrmhide Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 28873, "INV_Pants_Cloth_05", "=q3=High Warlord's Wyrmhide Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Druid2 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp701_3_a#", "" },
        { 31590, "INV_Helmet_30", "=q3=Grand Marshal's Kodohide Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31592, "INV_Shoulder_12", "=q3=Grand Marshal's Kodohide Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31593, "INV_Chest_Leather_03", "=q3=Grand Marshal's Kodohide Tunic", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31589, "INV_Gauntlets_28", "=q3=Grand Marshal's Kodohide Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31591, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Kodohide Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp701_3_h#", "" },
        { 31585, "INV_Helmet_30", "=q3=High Warlord's Kodohide Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 31587, "INV_Shoulder_12", "=q3=High Warlord's Kodohide Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31588, "INV_Chest_Leather_03", "=q3=High Warlord's Kodohide Tunic", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31584, "INV_Gauntlets_28", "=q3=High Warlord's Kodohide Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 31586, "INV_Pants_Cloth_05", "=q3=High Warlord's Kodohide Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };
        
    PVP70Hunter = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp702_a#", "" },
        { 28615, "INV_Helmet_09", "=q3=Grand Marshal's Chain Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28617, "INV_Shoulder_29", "=q3=Grand Marshal's Chain Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28613, "INV_Chest_Chain_11", "=q3=Grand Marshal's Chain Armor", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28614, "INV_Gauntlets_11", "=q3=Grand Marshal's Chain Gauntlets", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28616, "INV_Pants_Mail_15", "=q3=Grand Marshal's Chain Leggings", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp702_h#", "" },
        { 28807, "INV_Helmet_09", "=q3=High Warlord's Chain Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28809, "INV_Shoulder_29", "=q3=High Warlord's Chain Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28805, "INV_Chest_Chain_11", "=q3=High Warlord's Chain Armor", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28806, "INV_Gauntlets_11", "=q3=High Warlord's Chain Gauntlets", "", "", "10098", "#horde#", "20", "#av#" },
        { 28808, "INV_Pants_Mail_15", "=q3=High Warlord's Chain Leggings", "", "", "16065", "#horde#", "30", "#wsg#" },
        };
    
    PVP70Mage = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp703_a#", "" },
        { 28715, "INV_Helmet_08", "=q3=Grand Marshal's Silk Cowl", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28714, "INV_Shoulder_19", "=q3=Grand Marshal's Silk Amice", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28717, "INV_Chest_Leather_01", "=q3=Grand Marshal's Silk Raiment", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28716, "INV_Gauntlets_19", "=q3=Grand Marshal's Silk Handguards", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28718, "INV_Pants_07", "=q3=Grand Marshal's Silk Trousers", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp703_h#", "" },
        { 28867, "INV_Helmet_08", "=q3=High Warlord's Silk Cowl", "", "", "16065", "#horde#", "30", "#av#" },
        { 28866, "INV_Shoulder_19", "=q3=High Warlord's Silk Amice", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28869, "INV_Chest_Leather_01", "=q3=High Warlord's Silk Raiment", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28868, "INV_Gauntlets_19", "=q3=High Warlord's Silk Handguards", "", "", "10098", "#horde#", "20", "#av#" },
        { 28870, "INV_Pants_07", "=q3=High Warlord's Silk Trousers", "", "", "16065", "#horde#", "30", "#wsg#" },
       	};

    PVP70Paladin1 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp704_1_a#", "" },
        { 28681, "INV_Helmet_22", "=q3=Grand Marshal's Lamellar Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28683, "INV_Shoulder_22", "=q3=Grand Marshal's Lamellar Shoulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28679, "INV_Chest_Plate05", "=q3=Grand Marshal's Lamellar Chestpiece", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28680, "INV_Gauntlets_29", "=q3=Grand Marshal's Lamellar Gauntlets", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28724, "INV_Pants_Plate_17", "=q3=Grand Marshal's Lamellar Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp704_2_a#", "" },
        { 28711, "INV_Helmet_22", "=q3=Grand Marshal's Scaled Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28713, "INV_Shoulder_22", "=q3=Grand Marshal's Scaled Shoulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28709, "INV_Chest_Plate05", "=q3=Grand Marshal's Scaled Chestpiece", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28710, "INV_Gauntlets_29", "=q3=Grand Marshal's Scaled Gauntlets", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28712, "INV_Pants_Plate_17", "=q3=Grand Marshal's Scaled Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp704_1_h#", "" },
        { 28833, "INV_Helmet_22", "=q3=High Warlord's Lamellar Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28835, "INV_Shoulder_22", "=q3=High Warlord's Lamellar Shoulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28831, "INV_Chest_Plate05", "=q3=High Warlord's Lamellar Chestpiece", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28832, "INV_Gauntlets_29", "=q3=High Warlord's Lamellar Gauntlets", "", "", "10098", "#horde#", "20", "#av#" },
        { 28834, "INV_Pants_Plate_17", "=q3=High Warlord's Lamellar Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp704_2_h#", "" },
        { 28863, "INV_Helmet_22", "=q3=High Warlord's Scaled Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28865, "INV_Shoulder_22", "=q3=High Warlord's Scaled Shoulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28861, "INV_Chest_Plate05", "=q3=High Warlord's Scaled Chestpiece", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28862, "INV_Gauntlets_29", "=q3=High Warlord's Scaled Gauntlets", "", "", "10098", "#horde#", "20", "#av#" },
        { 28864, "INV_Pants_Plate_17", "=q3=High Warlord's Scaled Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Paladin2 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp704_3_a#", "" },
        { 31632, "INV_Helmet_22", "=q3=Grand Marshal's Ornamented Headguard", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31634, "INV_Shoulder_22", "=q3=Grand Marshal's Ornamented Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31630, "INV_Chest_Plate05", "=q3=Grand Marshal's Ornamented Chestplate", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31631, "INV_Gauntlets_29", "=q3=Grand Marshal's Ornamented Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31633, "INV_Pants_Plate_17", "=q3=Grand Marshal's Ornamented Leggings", "", "", "16065", "#alliance#", "30", "#wsg#" },     
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp704_3_h#", "" },
        { 31637, "INV_Helmet_22", "=q3=High Warlord's Ornamented Headguard", "", "", "16065", "#horde#", "30", "#av#" },
        { 31639, "INV_Shoulder_22", "=q3=High Warlord's Ornamented Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31635, "INV_Chest_Plate05", "=q3=High Warlord's Ornamented Chestplate", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31636, "INV_Gauntlets_29", "=q3=High Warlord's Ornamented Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 31638, "INV_Pants_Plate_17", "=q3=High Warlord's Ornamented Leggings", "", "", "16065", "#horde#", "30", "#wsg#" },         };

    PVP70Priest = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp705_1_a#", "" },
        { 28705, "INV_Helmet_30", "=q3=Grand Marshal's Satin Hood", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28707, "INV_Shoulder_02", "=q3=Grand Marshal's Satin Mantle", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28708, "INV_Chest_Cloth_43", "=q3=Grand Marshal's Satin Robe", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28704, "INV_Gauntlets_15", "=q3=Grand Marshal's Satin Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28706, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Satin Leggings", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp705_2_a#", "" },
        { 31622, "INV_Helmet_30", "=q3=Grand Marshal's Mooncloth Cowl", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31624, "INV_Shoulder_02", "=q3=Grand Marshal's Mooncloth Shoulderpads", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31625, "INV_Chest_Cloth_43", "=q3=Grand Marshal's Mooncloth Vestments", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31620, "INV_Gauntlets_15", "=q3=Grand Marshal's Mooncloth Mitts", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31623, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Mooncloth Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp705_1_h#", "" },
        { 28857, "INV_Helmet_30", "=q3=High Warlord's Satin Hood", "", "", "16065", "#horde#", "30", "#av#" },
        { 28859, "INV_Shoulder_02", "=q3=High Warlord's Satin Mantle", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28860, "INV_Chest_Cloth_43", "=q3=High Warlord's Satin Robe", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28856, "INV_Gauntlets_15", "=q3=High Warlord's Satin Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 28858, "INV_Pants_Cloth_05", "=q3=High Warlord's Satin Leggings", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp705_2_h#", "" },
        { 31626, "INV_Helmet_30", "=q3=High Warlord's Mooncloth Cowl", "", "", "16065", "#horde#", "30", "#av#" },
        { 31628, "INV_Shoulder_02", "=q3=High Warlord's Mooncloth Shoulderpads", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31629, "INV_Chest_Cloth_43", "=q3=High Warlord's Mooncloth Vestments", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31621, "INV_Gauntlets_15", "=q3=High Warlord's Mooncloth Mitts", "", "", "10098", "#horde#", "20", "#av#" },
        { 31627, "INV_Pants_Cloth_05", "=q3=High Warlord's Mooncloth Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Rogue = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp706_a#", "" },
        { 28685, "INV_Helmet_30", "=q3=Grand Marshal's Leather Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28687, "INV_Shoulder_12", "=q3=Grand Marshal's Leather Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28688, "INV_Chest_Leather_03", "=q3=Grand Marshal's Leather Tunic", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28684, "INV_Gauntlets_28", "=q3=Grand Marshal's Leather Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28686, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Leather Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp706_h#", "" },
        { 28837, "INV_Helmet_30", "=q3=High Warlord's Leather Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28839, "INV_Shoulder_12", "=q3=High Warlord's Leather Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28840, "INV_Chest_Leather_03", "=q3=High Warlord's Leather Tunic", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28836, "INV_Gauntlets_28", "=q3=High Warlord's Leather Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 28838, "INV_Pants_Cloth_05", "=q3=High Warlord's Leather Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Shaman1 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp707_1_a#", "" },
        { 28691, "INV_Helmet_09", "=q3=Grand Marshal's Linked Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28693, "INV_Shoulder_29", "=q3=Grand Marshal's Linked Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28689, "INV_Chest_Chain_11", "=q3=Grand Marshal's Linked Armor", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28690, "INV_Gauntlets_11", "=q3=Grand Marshal's Linked Gauntlets", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28692, "INV_Pants_Mail_15", "=q3=Grand Marshal's Linked Leggings", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_02", "=q6=#pvp707_2_a#", "" },
        { 28696, "INV_Helmet_09", "=q3=Grand Marshal's Mail Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28698, "INV_Shoulder_29", "=q3=Grand Marshal's Mail Spaulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28694, "INV_Chest_Chain_11", "=q3=Grand Marshal's Mail Armor", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28695, "INV_Gauntlets_11", "=q3=Grand Marshal's Mail Gauntlets", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28697, "INV_Pants_Mail_15", "=q3=Grand Marshal's Mail Leggings", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp707_1_h#", "" },
        { 28843, "INV_Helmet_09", "=q3=High Warlord's Linked Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28845, "INV_Shoulder_29", "=q3=High Warlord's Linked Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28841, "INV_Chest_Chain_11", "=q3=High Warlord's Linked Armor", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28842, "INV_Gauntlets_11", "=q3=High Warlord's Linked Gauntlets", "", "", "10098", "#horde#", "20", "#av#" },
        { 28844, "INV_Pants_Mail_15", "=q3=High Warlord's Linked Leggings", "", "", "16065", "#horde#", "30", "#wsg#" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp707_2_h#", "" },
        { 28848, "INV_Helmet_09", "=q3=High Warlord's Mail Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28850, "INV_Shoulder_29", "=q3=High Warlord's Mail Spaulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28846, "INV_Chest_Chain_11", "=q3=High Warlord's Mail Armor", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28847, "INV_Gauntlets_11", "=q3=High Warlord's Mail Gauntlets", "", "", "10098", "#horde#", "20", "#av#" },
        { 28849, "INV_Pants_Mail_15", "=q3=High Warlord's Mail Leggings", "", "", "16065", "#horde#", "30", "#wsg#" },
        };
        
    PVP70Shaman2 = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp707_3_a#", "" },
        { 31642, "INV_Helmet_09", "=q3=Grand Marshal's Ringmail Headpiece", "", "", "16065", "#alliance#", "30", "#av#" },
        { 31644, "INV_Shoulder_29", "=q3=Grand Marshal's Ringmail Shoulderpads", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 31640, "INV_Chest_Chain_11", "=q3=Grand Marshal's Ringmail Chestpiece", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 31641, "INV_Gauntlets_11", "=q3=Grand Marshal's Ringmail Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 31643, "INV_Pants_Mail_15", "=q3=Grand Marshal's Ringmail Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp707_3_h#", "" },
        { 31648, "INV_Helmet_09", "=q3=High Warlord's Ringmail Headpiece", "", "", "16065", "#horde#", "30", "#av#" },
        { 31650, "INV_Shoulder_29", "=q3=High Warlord's Ringmail Shoulderpads", "", "", "10098", "#horde#", "20", "#ab#" },
        { 31646, "INV_Chest_Chain_11", "=q3=High Warlord's Ringmail Chestguard", "", "", "16524", "#horde#", "30", "#ab#" },
        { 31647, "INV_Gauntlets_11", "=q3=High Warlord's Ringmail Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 31649, "INV_Pants_Mail_15", "=q3=High Warlord's Ringmail Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Warlock = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp708_a#", "" },
        { 28625, "INV_Helmet_30", "=q3=Grand Marshal's Dreadweave Hood", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28627, "INV_Shoulder_02", "=q3=Grand Marshal's Dreadweave Mantle", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28628, "INV_Chest_Cloth_43", "=q3=Grand Marshal's Dreadweave Robe", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28624, "INV_Gauntlets_15", "=q3=Grand Marshal's Dreadweave Gloves", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28626, "INV_Pants_Cloth_05", "=q3=Grand Marshal's Dreadweave Leggings", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
	{ 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp708_h#", "" },
        { 28818, "INV_Helmet_30", "=q3=High Warlord's Dreadweave Hood", "", "", "16065", "#horde#", "30", "#av#" },
        { 28820, "INV_Shoulder_02", "=q3=High Warlord's Dreadweave Mantle", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28821, "INV_Chest_Cloth_43", "=q3=High Warlord's Dreadweave Robe", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28817, "INV_Gauntlets_15", "=q3=High Warlord's Dreadweave Gloves", "", "", "10098", "#horde#", "20", "#av#" },
        { 28819, "INV_Pants_Cloth_05", "=q3=High Warlord's Dreadweave Leggings", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

    PVP70Warrior = {
        { 0, "INV_BannerPVP_02", "=q6=#pvp709_a#", "" },
        { 28701, "INV_Helmet_22", "=q3=Grand Marshal's Plate Helm", "", "", "16065", "#alliance#", "30", "#av#" },
        { 28703, "INV_Shoulder_22", "=q3=Grand Marshal's Plate Shoulders", "", "", "10098", "#alliance#", "20", "#ab#" },
        { 28699, "INV_Chest_Plate05", "=q3=Grand Marshal's Plate Chestpiece", "", "", "16524", "#alliance#", "30", "#ab#" },
        { 28700, "INV_Gauntlets_29", "=q3=Grand Marshal's Plate Gauntlets", "", "", "10098", "#alliance#", "20", "#av#" },
        { 28702, "INV_Pants_Plate_17", "=q3=Grand Marshal's Plate Legguards", "", "", "16065", "#alliance#", "30", "#wsg#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_BannerPVP_01", "=q6=#pvp709_h#", "" },
        { 28853, "INV_Helmet_22", "=q3=High Warlord's Plate Helm", "", "", "16065", "#horde#", "30", "#av#" },
        { 28855, "INV_Shoulder_22", "=q3=High Warlord's Plate Shoulders", "", "", "10098", "#horde#", "20", "#ab#" },
        { 28851, "INV_Chest_Plate05", "=q3=High Warlord's Plate Chestpiece", "", "", "16524", "#horde#", "30", "#ab#" },
        { 28852, "INV_Gauntlets_29", "=q3=High Warlord's Plate Gauntlets", "", "", "10098", "#horde#", "20", "#av#" },
        { 28854, "INV_Pants_Plate_17", "=q3=High Warlord's Plate Legguards", "", "", "16065", "#horde#", "30", "#wsg#" },
        };

-- Legendary Items

    Legendaries = {
        { 22736, "INV_Sword_61", "=q5=Andonisus, Reaper of Souls", "=q1=#m26#: =ds=#h3#, #w10#" },
        { 19019, "INV_Sword_39", "=q5=Thunderfury, Blessed Blade of the Windseeker", "=ds=#h1#, #w10#" },
        { 17182, "INV_Hammer_Unique_Sulfuras", "=q5=Sulfuras, Hand of Ragnaros", "=ds=#h2#, #w6#" },
        { 21176, "INV_Misc_QirajiCrystal_05", "=q5=Black Qiraji Resonating Crystal", "=ds=#e12#" },
        { 0,"","","" },
        { 22632, "INV_Staff_Medivh", "=q5=Atiesh, Greatstaff of the Guardian", "=ds=#w9#, =q1=#m1# =ds=#c1#"},
        { 22589, "INV_Staff_Medivh", "=q5=Atiesh, Greatstaff of the Guardian", "=ds=#w9#, =q1=#m1# =ds=#c3#"},
        { 22631, "INV_Staff_Medivh", "=q5=Atiesh, Greatstaff of the Guardian", "=ds=#w9#, =q1=#m1# =ds=#c5#"},
        { 22630, "INV_Staff_Medivh", "=q5=Atiesh, Greatstaff of the Guardian", "=ds=#w9#, =q1=#m1# =ds=#c8#"},
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32837, "INV_Weapon_Glave_01", "=q5=Warglaive of Azzinoth", "=ds=#h3#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 32838, "INV_Weapon_Glave_01", "=q5=Warglaive of Azzinoth", "=ds=#h4#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 0,"","","" },
        { 30312, "INV_Weapon_Shortblade_47", "=q5=Infinity Blade", "=q1=#m26#: =ds=#h1#, #w4#" },
        { 30311, "INV_Sword_69", "=q5=Warp Slicer", "=q1=#m26#: =ds=#h1#, #w10#" },
        { 30317, "INV_Mace_48", "=q5=Cosmic Infuser", "=q1=#m26#: =ds=#h3#, #w6#" },
        { 30316, "INV_Axe_68", "=q5=Devastation", "=q1=#m26#: =ds=#h2#, #w1#" },
        { 30313, "INV_Staff_52", "=q5=Staff of Disintegration", "=q1=#m26#: =ds=#w9#" },
        { 30318, "INV_Weapon_Bow_19", "=q5=Netherstrand Longbow", "=q1=#m26#: =ds=#w2#, =q1=#m1# =ds=#c2#" },
        { 30314, "INV_Shield_31", "=q5=Phaseshift Bulwark", "=q1=#m26#: =ds=#w8#" },
        { 30319, "Spell_Arcane_Starfire", "=q5=Nether Spike", "=q1=#m26#: =ds=#w17#" },
        };

-- Heroic Mode Token Rewards
        
    HardModeToken = {
        { 29368, "INV_Jewelry_Necklace_30Naxxramas", "=q4=Manasurge Pendant", "=ds=#s2#", "", "25", "#heroic#" },
        { 29374, "INV_Jewelry_Necklace_31", "=q4=Necklace of Eternal Hope", "=ds=#s2#", "", "25", "#heroic#" },
        { 29381, "INV_Jewelry_Necklace_04", "=q4=Choker of Vile Intent", "=ds=#s2#", "", "25", "#heroic#" },
        { 29386, "INV_Jewelry_Necklace_AhnQiraj_03", "=q4=Necklace of the Juggernaut", "=ds=#s2#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 29367, "INV_Jewelry_Ring_56", "=q4=Ring of Cryptic Dreams", "=ds=#s13#", "", "25", "#heroic#" },
        { 29373, "INV_Jewelry_Ring_53Naxxramas", "=q4=Band of Halos", "=ds=#s13#", "", "25", "#heroic#" },
        { 29379, "INV_jewelry_ring_AhnQiraj_01", "=q4=Ring of Arathi Warlords", "=ds=#s13#", "", "25", "#heroic#" },
        { 29384, "INV_Jewelry_Ring_46", "=q4=Ring of Unyielding Force", "=ds=#s13#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 29370, "INV_Weapon_ShortBlade_23", "=q4=Icon of the Silver Crescent", "=ds=#s14#", "", "41", "#heroic#" },
        { 29376, "INV_ValentinePerfumeBottle", "=q4=Essence of the Martyr", "=ds=#s14#", "", "41", "#heroic#" },
        { 29383, "INV_Misc_MonsterScales_15", "=q4=Bloodlust Brooch", "=ds=#s14#", "", "41", "#heroic#" },
        { 29387, "INV_Battery_02", "=q4=Gnomeregan Auto-Blocker 600", "=ds=#s14#", "", "41", "#heroic#" },
        { 0,"","","" },
        { 29273, "INV_Misc_Bag_10_Green", "=q4=Khadgar's Knapsack", "=ds=#s15#", "", "25", "#heroic#" },
        { 29271, "INV_Offhand_OutlandRaid_02", "=q4=Talisman of Kalecgos", "=ds=#s15#", "", "25", "#heroic#" },
        { 29270, "Spell_Fire_SealOfFire", "=q4=Flametounge Seal", "=ds=#s15#", "", "25", "#heroic#" },
        { 29269, "INV_Misc_Bone_01", "=q4=Sapphiron's Wing Bone", "=ds=#s15#", "", "25", "#heroic#" },
        { 29274, "INV_Potion_75", "=q4=Tears of Heaven", "=ds=#s15#", "", "25", "#heroic#" },
        { 29272, "INV_Misc_Orb_04", "=q4=Orb of the Soul-Eater", "=ds=#s15#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 29390, "INV_Relics_IdolofHealth", "=q4=Everbloom Idol", "", "", "15", "#heroic#" },
        { 29388, "INV_Relics_LibramofHope", "=q4=Libram of Repentance", "", "", "15", "#heroic#" },
        { 29389, "INV_Elemental_Primal_Earth", "=q4=Totem of the Pulsing Earth", "", "", "15", "#heroic#" },
        { 0,"","","" },
        { 23572, "INV_Elemental_Primal_Nether", "=q3=Primal Nether", "=ds=#e28#", "", "10", "#heroic#" },
        { 0,"","","" },
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#m17#" },
        };
        
    HardModeToken2 = {
        { 0, "INV_Box_01", "=q6=#a1#", "" },
        { 30762, "INV_Chest_Cloth_18", "=q4=Infernoweave Robe", "=ds=#a1#, #s5#", "", "30", "#heroic#" },
        { 30764, "INV_Gauntlets_26", "=q4=Infernoweave Gloves", "=ds=#a1#, #s9#", "", "20", "#heroic#" },
        { 30761, "INV_Pants_06", "=q4=Infernoweave Leggings", "=ds=#a1#, #s11#", "", "30", "#heroic#" },
        { 30763, "INV_Boots_02", "=q4=Infernoweave Boots", "=ds=#a1#, #s12#", "", "20", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#a2#", "" },
        { 30776, "INV_Chest_Leather_07", "=q4=Inferno Hardened Chestguard", "=ds=#a2#, #s5#", "", "30", "#heroic#" },
        { 30780, "INV_Gauntlets_26", "=q4=Inferno Hardened Gloves", "=ds=#a2#, #s9#", "", "20", "#heroic#" },
        { 30778, "INV_Pants_Leather_18", "=q4=Inferno Hardened Leggings", "=ds=#a2#, #s11#", "", "30", "#heroic#" },
        { 30779, "INV_Boots_07", "=q4=Inferno Hardened Boots", "=ds=#a2#, #s12#", "", "20", "#heroic#" },
        { 0,"","","" },
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#m17#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#a3#", "" },
        { 30773, "INV_Chest_Plate08", "=q4=Inferno Forged Hauberk", "=ds=#a3#, #s5#", "", "30", "#heroic#" },
        { 30774, "INV_Gauntlets_10", "=q4=Inferno Forged Gloves", "=ds=#a3#, #s9#", "", "20", "#heroic#" },
        { 30772, "INV_Pants_Mail_14", "=q4=Inferno Forged Leggings", "=ds=#a3#, #s11#", "", "30", "#heroic#" },
        { 30770, "INV_Boots_Chain_08", "=q4=Inferno Forged Boots", "=ds=#a3#, #s12#", "", "20", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#a4#", "" },
        { 30769, "INV_Chest_Plate08", "=q4=Inferno Tempered Chestguard", "=ds=#a4#, #s5#", "", "30", "#heroic#" },
        { 30767, "INV_Gauntlets_22", "=q4=Inferno Tempered Gauntlets", "=ds=#a4#, #s9#", "", "20", "#heroic#" },
        { 30766, "INV_Pants_04", "=q4=Inferno Tempered Leggings", "=ds=#a4#, #s11#", "", "30", "#heroic#" },
        { 30768, "INV_Boots_Chain_08", "=q4=Inferno Tempered Boots", "=ds=#a4#, #s12#", "", "20", "#heroic#" },
        };
        
    HardModeToken3 = {
        { 0, "INV_Box_01", "=q6=#s1#", "" },
        { 32089, "INV_Helmet_30", "=q4=Mana-Binders Cowl", "=ds=#a1#, #s1#", "", "50", "#heroic#" },
        { 32090, "INV_Helmet_30", "=q4=Cowl of Naaru Blessings", "=ds=#a1#, #s1#", "", "50", "#heroic#" },
        { 32088, "INV_Helmet_38", "=q4=Cowl of Beastly Rage", "=ds=#a2#, #s1#", "", "50", "#heroic#" },
        { 32087, "INV_Helmet_73", "=q4=Mask of the Deceiver", "=ds=#a2#, #s1#", "", "50", "#heroic#" },
        { 32086, "INV_Helmet_69", "=q4=Storm Master's Helmet", "=ds=#a3#, #s1#", "", "50", "#heroic#" },
        { 32085, "INV_Helmet_72", "=q4=Warpstalker Helm", "=ds=#a3#, #s1#", "", "50", "#heroic#" },
        { 32083, "INV_Helmet_01", "=q4=Faceguard of Determination", "=ds=#a4#, #s1#", "", "50", "#heroic#" },
        { 32084, "INV_Helmet_16", "=q4=Helmet of the Steadfast Champion", "=ds=#a4#, #s1#", "", "50", "#heroic#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#m17#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#s4#", "" },
        { 29369, "INV_Misc_Cape_16", "=q4=Shawl of Shifting Probabilities", "=ds=#s4#", "", "25", "#heroic#" },
        { 29375, "INV_Misc_Cape_02", "=q4=Bishop's Cloak", "=ds=#s4#", "", "25", "#heroic#" },
        { 29382, "INV_Misc_Cape_18", "=q4=Blood Knight War Cloak", "=ds=#s4#", "", "25", "#heroic#" },
        { 29385, "INV_Misc_Cape_Naxxramas_02", "=q4=Farstrider Defender's Cloak", "=ds=#s4#", "", "25", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#w8#", "" },
        { 29268, "INV_Shield_37", "=q4=Mazthoril Honor Shield", "=ds=#w8#", "", "33", "#heroic#" },
        { 29267, "INV_Shield_33", "=q4=Light-Bearer's Faith Shield", "=ds=#w8#", "", "33", "#heroic#" },
        { 29266, "INV_Shield_33", "=q4=Azure-Shield of Coldarra", "=ds=#w8#", "", "33", "#heroic#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#w4#", "" },
        { 29275, "INV_knife_1h_stratholme_d_03", "=q4=Searing Sunblade", "=ds=#h4# #w4#", "", "50", "#heroic#" },
        };

-- Rare Mounts
        
    RareMounts = {
        { 21176, "INV_Misc_QirajiCrystal_05", "=q5=Black Qiraji Resonating Crystal", "=q2=#m4#" },
	{ 0,"","","" },
        { 13335, "Ability_Mount_Undeadhorse", "=q4=Deathcharger's Reins", "=q2=#n52#, =q1=#z6#", "0.10%" },
        { 19872, "Ability_Mount_Raptor", "=q4=Swift Razzashi Raptor",   "=q2=#n33#, =q1=#z8#", "0.43%" },
        { 19902, "Ability_Mount_JungleTiger", "=q4=Swift Zulian Tiger", "=q2=#n28#, =q1=#z8#", " 0.70%" },
        { 13086, "Ability_Mount_PinkTiger", "=q4=Reins of the Winterspring Frostsaber", "=ds=#e12#" },
	{ 33225, "Ability_Mount_WhiteTiger", "=q4=Reins of the Swift Spectral Tiger", "=q2=#m24#" },
        { 23720, "Ability_Hunter_Pet_Turtle", "=q4=Riding Turtle", "=q2=#m24#" },
	{ 0,"","","" },
        { 21218, "INV_Misc_QirajiCrystal_04", "=q3=Blue Qiraji Resonating Crystal", "=q2=#n11#,  =q1=#z11#", "10.91%" },
        { 21323, "INV_Misc_QirajiCrystal_03", "=q3=Green Qiraji Resonating Crystal", "=q2=#n11#,  =q1=#z11#", "11.77%" },
        { 21321, "INV_Misc_QirajiCrystal_02", "=q3=Red Qiraji Resonating Crystal", "=q2=#n11#,  =q1=#z11#", "1.32%" },
        { 21324, "INV_Misc_QirajiCrystal_01", "=q3=Yellow Qiraji Resonating Crystal", "=q2=#n11#,  =q1=#z11#", "12.64%" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 30609, "Ability_Mount_NetherDrakeElite", "=q4=Swift Nether Drake", "=q2=#m25#" },
	{ 0,"","","" },
        { 32458, "Inv_Misc_Summerfest_Brazierorange", "=q4=Ashes of Al'ar", "=q2=#n59#, =q1=#z19#" },
        { 30480, "Ability_Mount_Dreadsteed", "=q4=Fiery Warhorse's Reins", "=q2=#n53#, =q1=#z12#", "0.25%" },
        { 32768, "INV-Mount_Raven_54", "=q4=Reins of the Raven Lord", "=q2=#n58#, =q1=#z16#" },
        };

-- Tabards
    
    Tabards1 = {
        { 23705, "INV_Misc_TabardPVP_02", "=q4=Tabard of Flame", "=ds=#s7#, =q1=#m24#" },
        { 23709, "INV_Misc_TabardPVP_01", "=q4=Tabard of Frost", "=ds=#s7#, =q1=#m24#" },
        { 31404, "INV_Shirt_15", "=q2=Green Trophy Tabard of the Illidari", "=ds=#s7#, =q1=#m4#" },
        { 31405, "INV_Shirt_15", "=q2=Purple Trophy Tabard of the Illidari", "=ds=#s7#, =q1=#m4#" },
        { 23192, "INV_Misc_Cape_18", "=q2=Tabard of the Scarlet Crusade", "=ds=#s7#", "0.48%" },
        { 0,"","","" },
        { 31779, "INV_Shirt_GuildTabard_01", "=q1=Aldor Tabard", "=ds=#s7#" },
        { 31804, "INV_Shirt_GuildTabard_01", "=q1=Cenarion Expedition Tabard", "=ds=#s7#" },
        { 23999, "INV_Shirt_GuildTabard_01", "=q1=Honor Hold Tabard", "=ds=#s7#, =ec1=#m7#" },
        { 31778, "INV_Shirt_GuildTabard_01", "=q1=Lower City Tabard", "=ds=#s7#" },
        { 32828, "INV_Shirt_GuildTabard_01", "=q1=Ogri'la Tabard", "=ds=#s7#" },
        { 31781, "INV_Shirt_GuildTabard_01", "=q1=Sha'tar Tabard", "=ds=#s7#" },
        { 31775, "INV_Shirt_GuildTabard_01", "=q1=Sporeggar Tabard", "=ds=#s7#" },
        { 22999, "INV_Shirt_GuildTabard_01", "=q1=Tabard of the Agent Dawn", "=ds=#s7#, =q1=#m4#" },
        { 24004, "INV_Shirt_GuildTabard_01", "=q1=Thrallmar Tabard", "=ds=#s7#, =ec1=#m6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 25549, "INV_Shirt_GuildTabard_01", "=q1=Blood Knight Tabard", "=ds=#s7#, =ec1=#m6#" },
        { 31776, "INV_Shirt_GuildTabard_01", "=q1=Consortium Tabard", "=ds=#s7#" },
        { 31774, "INV_Shirt_GuildTabard_01", "=q1=Kurenai Tabard", "=ds=#s7#, =ec1=#m7#" },
        { 31773, "INV_Shirt_GuildTabard_01", "=q1=Mag'har Tabard", "=ds=#s7#, =ec1=#m6#" },
        { 31780, "INV_Shirt_GuildTabard_01", "=q1=Scryers Tabard", "=ds=#s7#" },
        { 32445, "INV_Shirt_GuildTabard_01", "=q1=Skyguard Tabard", "=ds=#s7#" },
        { 24344, "INV_Shirt_12", "=q1=Tabard of the Hand", "=ds=#s7#, =q1=#m4#, =ec1=#m7#" },
        { 28788, "INV_Shirt_GuildTabard_01", "=q1=Tabard of the Protector", "=ds=#s7#, =q1=#m4#" },        
        };
        
    Tabards2 = {
        { 20132, "INV_Shirt_GuildTabard_01", "=q1=Arathor Battle Tabard", "=ds=#s7#, =q1=#m4#, =ec1=#m7#" },
        { 20131, "INV_Shirt_GuildTabard_01", "=q1=Battle Tabard of the Defilers", "=ds=#s7#, =q1=#m4#, =ec1=#m6#" },
        { 19032, "INV_Shirt_GuildTabard_01", "=q1=Stormpike Battle Tabard", "=ds=#s7#, =ec1=#m7#" },
        { 19031, "INV_Shirt_GuildTabard_01", "=q1=Frostwolf Battle Tabard", "=ds=#s7#, =ec1=#m6#" },
        { 19506, "INV_Shirt_GuildTabard_01", "=q1=Silverwing Battle Tabard", "=ds=#s7#, =ec1=#m7#" },
        { 19505, "INV_Shirt_GuildTabard_01", "=q1=Warsong Battle Tabard", "=ds=#s7#, =ec1=#m6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 15196, "INV_Misc_TabardPVP_01", "=q1=Private's Tabard", "=ds=#s7#, =ec1=#m7#" },
        { 15198, "INV_Misc_TabardPVP_03", "=q1=Knight's Colors", "=ds=#s7#, =ec1=#m7#" },        
        { 15197, "INV_Misc_TabardPVP_02", "=q1=Scout's Tabard", "=ds=#s7#, =ec1=#m6#" },
        { 15199, "INV_Misc_TabardPVP_04", "=q1=Stone Guard's Herald", "=ds=#s7#, =ec1=#m6#" },
        };

-- Card Game Items

    CardGame1 = {
        { 0, "INV_Box_01", "=q6=#ud4#", "=q1=#ud1#" },
        { 23705, "INV_Misc_TabardPVP_02", "=q4=Tabard of Flame", "=ds=#s7# =q1=#ud6#", },
        { 23713, "INV_Egg_02", "=q4=Hippogryph Hatchling", "=ds=#e13# =q1=#ud7#", },
        { 23720, "Ability_Hunter_Pet_Turtle", "=q4=Riding Turtle", "=ds=#e12# =q1=#ud8#", },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#ud4#", "=q1=#ud2#" },
        { 32588, "INV_Misc_Food_24", "=q3=Banana Charm", "=ds=#e13# =q1=#ud9#", },
        { 32566, "INV_Box_01", "=q3=Picnic Basket", "=ds=#m20# =q1=#ud10#", },
        { 32542, "INV_Potion_27", "=q3=Imp in a Ball", "=ds=#m20# =q1=#ud11#", },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#ud4#", "=q1=#ud3#" },
        { 33225, "Ability_Mount_WhiteTiger", "=q4=Reins of the Swift Spectral Tiger", "=ds=#e12# =q1=#ud14#", },
        { 33224, "Ability_Mount_WhiteTiger", "=q3=Reins of the Spectral Tiger", "=ds=#e12# =q1=#ud14#", },
        { 33223, "INV_FISHINGCHAIR", "=q3=Fishing Chair", "=q1=#ud13#", },
        { 33219, "INV_Drink_17", "=q3=Goblin Gumbeaux Kettle", "=q1=#ud12#", },
        { 0, "INV_Box_01", "=q6=#ud5#", "" },
        { 23709, "INV_Misc_TabardPVP_01", "=q4=Tabard of Frost", "=ds=#s7#", },
        { 23714, "INV_Misc_MissileSmall_Purple", "=q4=Perpetual Purple Firework", "=ds=#s14#", },
        { 23716, "INV_Misc_Idol_01", "=q4=Carved Ogre Idol", "=ds=#s14#", },
        };
    
    };
    